package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Delete Security Group Staging Default operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteSecurityGroupStagingDefaultRequest"})
public final class DeleteSecurityGroupStagingDefaultRequest
    extends org.cloudfoundry.client.v2.securitygroups._DeleteSecurityGroupStagingDefaultRequest {
  private final String securityGroupStagingDefaultId;

  private DeleteSecurityGroupStagingDefaultRequest(DeleteSecurityGroupStagingDefaultRequest.Builder builder) {
    this.securityGroupStagingDefaultId = builder.securityGroupStagingDefaultId;
  }

  /**
   * The security group staging default id
   */
  @Override
  public String getSecurityGroupStagingDefaultId() {
    return securityGroupStagingDefaultId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteSecurityGroupStagingDefaultRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteSecurityGroupStagingDefaultRequest
        && equalTo((DeleteSecurityGroupStagingDefaultRequest) another);
  }

  private boolean equalTo(DeleteSecurityGroupStagingDefaultRequest another) {
    return securityGroupStagingDefaultId.equals(another.securityGroupStagingDefaultId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupStagingDefaultId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + securityGroupStagingDefaultId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteSecurityGroupStagingDefaultRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteSecurityGroupStagingDefaultRequest{"
        + "securityGroupStagingDefaultId=" + securityGroupStagingDefaultId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteSecurityGroupStagingDefaultRequest DeleteSecurityGroupStagingDefaultRequest}.
   * @return A new DeleteSecurityGroupStagingDefaultRequest builder
   */
  public static DeleteSecurityGroupStagingDefaultRequest.Builder builder() {
    return new DeleteSecurityGroupStagingDefaultRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteSecurityGroupStagingDefaultRequest DeleteSecurityGroupStagingDefaultRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_STAGING_DEFAULT_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupStagingDefaultId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteSecurityGroupStagingDefaultRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteSecurityGroupStagingDefaultRequest instance) {
      return from((_DeleteSecurityGroupStagingDefaultRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteSecurityGroupStagingDefaultRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteSecurityGroupStagingDefaultRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupStagingDefaultId(instance.getSecurityGroupStagingDefaultId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteSecurityGroupStagingDefaultRequest#getSecurityGroupStagingDefaultId() securityGroupStagingDefaultId} attribute.
     * @param securityGroupStagingDefaultId The value for securityGroupStagingDefaultId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupStagingDefaultId(String securityGroupStagingDefaultId) {
      this.securityGroupStagingDefaultId = Objects.requireNonNull(securityGroupStagingDefaultId, "securityGroupStagingDefaultId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_STAGING_DEFAULT_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteSecurityGroupStagingDefaultRequest DeleteSecurityGroupStagingDefaultRequest}.
     * @return An immutable instance of DeleteSecurityGroupStagingDefaultRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteSecurityGroupStagingDefaultRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteSecurityGroupStagingDefaultRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_STAGING_DEFAULT_ID) != 0) attributes.add("securityGroupStagingDefaultId");
      return "Cannot build DeleteSecurityGroupStagingDefaultRequest, some of required attributes are not set " + attributes;
    }
  }
}
