package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UpdateSecurityGroupRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateSecurityGroupRequest.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateSecurityGroupRequest"})
public final class UpdateSecurityGroupRequest
    extends org.cloudfoundry.client.v2.securitygroups._UpdateSecurityGroupRequest {
  private final String securityGroupId;
  private final String name;
  private final @Nullable List<RuleEntity> rules;
  private final @Nullable List<String> spaceIds;

  private UpdateSecurityGroupRequest(UpdateSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
    this.name = builder.name;
    this.rules = builder.rules == null ? null : createUnmodifiableList(true, builder.rules);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The security group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * The security group name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The security group rules
   */
  @Override
  public @Nullable List<RuleEntity> getRules() {
    return rules;
  }

  /**
   * The list of associated spaces
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSecurityGroupRequest
        && equalTo((UpdateSecurityGroupRequest) another);
  }

  private boolean equalTo(UpdateSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId)
        && name.equals(another.name)
        && Objects.equals(rules, another.rules)
        && Objects.equals(spaceIds, another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}, {@code name}, {@code rules}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + securityGroupId.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(rules);
    h = h * 17 + Objects.hashCode(spaceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + ", name=" + name
        + ", rules=" + rules
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
   * @return A new UpdateSecurityGroupRequest builder
   */
  public static UpdateSecurityGroupRequest.Builder builder() {
    return new UpdateSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private String securityGroupId;
    private String name;
    private List<RuleEntity> rules = null;
    private List<String> spaceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSecurityGroupRequest instance) {
      return from((_UpdateSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      name(instance.getName());
      List<RuleEntity> rulesValue = instance.getRules();
      if (rulesValue != null) {
        addAllRules(rulesValue);
      }
      List<String> spaceIdsValue = instance.getSpaceIds();
      if (spaceIdsValue != null) {
        addAllSpaceIds(spaceIdsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateSecurityGroupRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSecurityGroupRequest#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(RuleEntity element) {
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(RuleEntity... elements) {
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      for (RuleEntity element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(@Nullable Iterable<? extends RuleEntity> elements) {
      if (elements == null) {
        this.rules = null;
        return this;
      }
      this.rules = new ArrayList<RuleEntity>();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link _UpdateSecurityGroupRequest#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends RuleEntity> elements) {
      Objects.requireNonNull(elements, "rules element");
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      for (RuleEntity element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _UpdateSecurityGroupRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateSecurityGroupRequest UpdateSecurityGroupRequest}.
     * @return An immutable instance of UpdateSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build UpdateSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
