package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for Service Instances
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "_ServiceInstanceEntity"})
public final class ServiceInstanceEntity
    extends org.cloudfoundry.client.v2.serviceinstances._ServiceInstanceEntity {
  private final @Nullable String dashboardUrl;
  private final @Nullable GatewayData gatewayData;
  private final @Nullable LastOperation lastOperation;
  private final @Nullable String serviceKeysUrl;
  private final @Nullable String servicePlanId;
  private final @Nullable String servicePlanUrl;
  private final @Nullable List<String> tags;
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String name;
  private final @Nullable String routesUrl;
  private final @Nullable String serviceBindingsUrl;
  private final @Nullable String spaceId;
  private final @Nullable String spaceUrl;
  private final @Nullable String type;

  private ServiceInstanceEntity(ServiceInstanceEntity.Builder builder) {
    this.dashboardUrl = builder.dashboardUrl;
    this.gatewayData = builder.gatewayData;
    this.lastOperation = builder.lastOperation;
    this.serviceKeysUrl = builder.serviceKeysUrl;
    this.servicePlanId = builder.servicePlanId;
    this.servicePlanUrl = builder.servicePlanUrl;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.routesUrl = builder.routesUrl;
    this.serviceBindingsUrl = builder.serviceBindingsUrl;
    this.spaceId = builder.spaceId;
    this.spaceUrl = builder.spaceUrl;
    this.type = builder.type;
  }

  /**
   * The dashboard url
   */
  @JsonProperty("dashboard_url")
  @Override
  public @Nullable String getDashboardUrl() {
    return dashboardUrl;
  }

  /**
   * The gateway data
   */
  @JsonProperty("gateway_data")
  @Deprecated
  @Override
  public @Nullable GatewayData getGatewayData() {
    return gatewayData;
  }

  /**
   * The last operation
   */
  @JsonProperty("last_operation")
  @Override
  public @Nullable LastOperation getLastOperation() {
    return lastOperation;
  }

  /**
   * The service keys url
   */
  @JsonProperty("service_keys_url")
  @Override
  public @Nullable String getServiceKeysUrl() {
    return serviceKeysUrl;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public @Nullable String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The service plan url
   */
  @JsonProperty("service_plan_url")
  @Override
  public @Nullable String getServicePlanUrl() {
    return servicePlanUrl;
  }

  /**
   * The tags
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The routes url
   */
  @JsonProperty("routes_url")
  @Override
  public @Nullable String getRoutesUrl() {
    return routesUrl;
  }

  /**
   * The service bindings url
   */
  @JsonProperty("service_bindings_url")
  @Override
  public @Nullable String getServiceBindingsUrl() {
    return serviceBindingsUrl;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space url
   */
  @JsonProperty("space_url")
  @Override
  public @Nullable String getSpaceUrl() {
    return spaceUrl;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstanceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstanceEntity
        && equalTo((ServiceInstanceEntity) another);
  }

  private boolean equalTo(ServiceInstanceEntity another) {
    return Objects.equals(dashboardUrl, another.dashboardUrl)
        && Objects.equals(gatewayData, another.gatewayData)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(serviceKeysUrl, another.serviceKeysUrl)
        && Objects.equals(servicePlanId, another.servicePlanId)
        && Objects.equals(servicePlanUrl, another.servicePlanUrl)
        && Objects.equals(tags, another.tags)
        && Objects.equals(credentials, another.credentials)
        && Objects.equals(name, another.name)
        && Objects.equals(routesUrl, another.routesUrl)
        && Objects.equals(serviceBindingsUrl, another.serviceBindingsUrl)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceUrl, another.spaceUrl)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code dashboardUrl}, {@code gatewayData}, {@code lastOperation}, {@code serviceKeysUrl}, {@code servicePlanId}, {@code servicePlanUrl}, {@code tags}, {@code credentials}, {@code name}, {@code routesUrl}, {@code serviceBindingsUrl}, {@code spaceId}, {@code spaceUrl}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(dashboardUrl);
    h = h * 17 + Objects.hashCode(gatewayData);
    h = h * 17 + Objects.hashCode(lastOperation);
    h = h * 17 + Objects.hashCode(serviceKeysUrl);
    h = h * 17 + Objects.hashCode(servicePlanId);
    h = h * 17 + Objects.hashCode(servicePlanUrl);
    h = h * 17 + Objects.hashCode(tags);
    h = h * 17 + Objects.hashCode(credentials);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(routesUrl);
    h = h * 17 + Objects.hashCode(serviceBindingsUrl);
    h = h * 17 + Objects.hashCode(spaceId);
    h = h * 17 + Objects.hashCode(spaceUrl);
    h = h * 17 + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstanceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstanceEntity{"
        + "dashboardUrl=" + dashboardUrl
        + ", gatewayData=" + gatewayData
        + ", lastOperation=" + lastOperation
        + ", serviceKeysUrl=" + serviceKeysUrl
        + ", servicePlanId=" + servicePlanId
        + ", servicePlanUrl=" + servicePlanUrl
        + ", tags=" + tags
        + ", credentials=" + credentials
        + ", name=" + name
        + ", routesUrl=" + routesUrl
        + ", serviceBindingsUrl=" + serviceBindingsUrl
        + ", spaceId=" + spaceId
        + ", spaceUrl=" + spaceUrl
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._ServiceInstanceEntity {
    String dashboardUrl;
    GatewayData gatewayData;
    LastOperation lastOperation;
    String serviceKeysUrl;
    String servicePlanId;
    String servicePlanUrl;
    List<String> tags = null;
    Map<String, Object> credentials;
    String name;
    String routesUrl;
    String serviceBindingsUrl;
    String spaceId;
    String spaceUrl;
    String type;
    @JsonProperty("dashboard_url")
    public void setDashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
    }
    @JsonProperty("gateway_data")
    public void setGatewayData(@Nullable GatewayData gatewayData) {
      this.gatewayData = gatewayData;
    }
    @JsonProperty("last_operation")
    public void setLastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
    }
    @JsonProperty("service_keys_url")
    public void setServiceKeysUrl(@Nullable String serviceKeysUrl) {
      this.serviceKeysUrl = serviceKeysUrl;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @JsonProperty("service_plan_url")
    public void setServicePlanUrl(@Nullable String servicePlanUrl) {
      this.servicePlanUrl = servicePlanUrl;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("routes_url")
    public void setRoutesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
    }
    @JsonProperty("service_bindings_url")
    public void setServiceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_url")
    public void setSpaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String getDashboardUrl() { throw new UnsupportedOperationException(); }
    @Override
    public GatewayData getGatewayData() { throw new UnsupportedOperationException(); }
    @Override
    public LastOperation getLastOperation() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceKeysUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBindingsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceInstanceEntity fromJson(Json json) {
    ServiceInstanceEntity.Builder builder = ServiceInstanceEntity.builder();
    if (json.dashboardUrl != null) {
      builder.dashboardUrl(json.dashboardUrl);
    }
    if (json.gatewayData != null) {
      builder.gatewayData(json.gatewayData);
    }
    if (json.lastOperation != null) {
      builder.lastOperation(json.lastOperation);
    }
    if (json.serviceKeysUrl != null) {
      builder.serviceKeysUrl(json.serviceKeysUrl);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    if (json.servicePlanUrl != null) {
      builder.servicePlanUrl(json.servicePlanUrl);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routesUrl != null) {
      builder.routesUrl(json.routesUrl);
    }
    if (json.serviceBindingsUrl != null) {
      builder.serviceBindingsUrl(json.serviceBindingsUrl);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceUrl != null) {
      builder.spaceUrl(json.spaceUrl);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceInstanceEntity ServiceInstanceEntity}.
   * @return A new ServiceInstanceEntity builder
   */
  public static ServiceInstanceEntity.Builder builder() {
    return new ServiceInstanceEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstanceEntity ServiceInstanceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String dashboardUrl;
    private GatewayData gatewayData;
    private LastOperation lastOperation;
    private String serviceKeysUrl;
    private String servicePlanId;
    private String servicePlanUrl;
    private List<String> tags = null;
    private Map<String, Object> credentials = null;
    private String name;
    private String routesUrl;
    private String serviceBindingsUrl;
    private String spaceId;
    private String spaceUrl;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstanceEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ServiceInstanceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.serviceinstances._ServiceInstanceEntity) {
        org.cloudfoundry.client.v2.serviceinstances._ServiceInstanceEntity instance = (org.cloudfoundry.client.v2.serviceinstances._ServiceInstanceEntity) object;
        String dashboardUrlValue = instance.getDashboardUrl();
        if (dashboardUrlValue != null) {
          dashboardUrl(dashboardUrlValue);
        }
        LastOperation lastOperationValue = instance.getLastOperation();
        if (lastOperationValue != null) {
          lastOperation(lastOperationValue);
        }
        String serviceKeysUrlValue = instance.getServiceKeysUrl();
        if (serviceKeysUrlValue != null) {
          serviceKeysUrl(serviceKeysUrlValue);
        }
        GatewayData gatewayDataValue = instance.getGatewayData();
        if (gatewayDataValue != null) {
          gatewayData(gatewayDataValue);
        }
        String servicePlanIdValue = instance.getServicePlanId();
        if (servicePlanIdValue != null) {
          servicePlanId(servicePlanIdValue);
        }
        List<String> tagsValue = instance.getTags();
        if (tagsValue != null) {
          addAllTags(tagsValue);
        }
        String servicePlanUrlValue = instance.getServicePlanUrl();
        if (servicePlanUrlValue != null) {
          servicePlanUrl(servicePlanUrlValue);
        }
      }
      if (object instanceof BaseServiceInstanceEntity) {
        BaseServiceInstanceEntity instance = (BaseServiceInstanceEntity) object;
        String spaceUrlValue = instance.getSpaceUrl();
        if (spaceUrlValue != null) {
          spaceUrl(spaceUrlValue);
        }
        String spaceIdValue = instance.getSpaceId();
        if (spaceIdValue != null) {
          spaceId(spaceIdValue);
        }
        Map<String, Object> credentialsValue = instance.getCredentials();
        if (credentialsValue != null) {
          putAllCredentials(credentialsValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String serviceBindingsUrlValue = instance.getServiceBindingsUrl();
        if (serviceBindingsUrlValue != null) {
          serviceBindingsUrl(serviceBindingsUrlValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String routesUrlValue = instance.getRoutesUrl();
        if (routesUrlValue != null) {
          routesUrl(routesUrlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getDashboardUrl() dashboardUrl} attribute.
     * @param dashboardUrl The value for dashboardUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dashboard_url")
    public final Builder dashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getGatewayData() gatewayData} attribute.
     * @param gatewayData The value for gatewayData (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("gateway_data")
    @Deprecated
    public final Builder gatewayData(@Nullable GatewayData gatewayData) {
      this.gatewayData = gatewayData;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_operation")
    public final Builder lastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getServiceKeysUrl() serviceKeysUrl} attribute.
     * @param serviceKeysUrl The value for serviceKeysUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_keys_url")
    public final Builder serviceKeysUrl(@Nullable String serviceKeysUrl) {
      this.serviceKeysUrl = serviceKeysUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_guid")
    public final Builder servicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getServicePlanUrl() servicePlanUrl} attribute.
     * @param servicePlanUrl The value for servicePlanUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_url")
    public final Builder servicePlanUrl(@Nullable String servicePlanUrl) {
      this.servicePlanUrl = servicePlanUrl;
      return this;
    }

    /**
     * Adds one element to {@link _ServiceInstanceEntity#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link _ServiceInstanceEntity#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ServiceInstanceEntity#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link _ServiceInstanceEntity#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceInstanceEntity#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getRoutesUrl() routesUrl} attribute.
     * @param routesUrl The value for routesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routes_url")
    public final Builder routesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getServiceBindingsUrl() serviceBindingsUrl} attribute.
     * @param serviceBindingsUrl The value for serviceBindingsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_bindings_url")
    public final Builder serviceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getSpaceUrl() spaceUrl} attribute.
     * @param spaceUrl The value for spaceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_url")
    public final Builder spaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceEntity#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstanceEntity ServiceInstanceEntity}.
     * @return An immutable instance of ServiceInstanceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstanceEntity build() {
      return new ServiceInstanceEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
