package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Delete Service Plan request.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteServicePlanRequest"})
public final class DeleteServicePlanRequest
    extends org.cloudfoundry.client.v2.serviceplans._DeleteServicePlanRequest {
  private final @Nullable Boolean async;
  private final String servicePlanId;

  private DeleteServicePlanRequest(DeleteServicePlanRequest.Builder builder) {
    this.async = builder.async;
    this.servicePlanId = builder.servicePlanId;
  }

  /**
   * The async
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The service plan id
   */
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServicePlanRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServicePlanRequest
        && equalTo((DeleteServicePlanRequest) another);
  }

  private boolean equalTo(DeleteServicePlanRequest another) {
    return Objects.equals(async, another.async)
        && servicePlanId.equals(another.servicePlanId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code servicePlanId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + servicePlanId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServicePlanRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServicePlanRequest{"
        + "async=" + async
        + ", servicePlanId=" + servicePlanId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServicePlanRequest DeleteServicePlanRequest}.
   * @return A new DeleteServicePlanRequest builder
   */
  public static DeleteServicePlanRequest.Builder builder() {
    return new DeleteServicePlanRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServicePlanRequest DeleteServicePlanRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String servicePlanId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServicePlanRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServicePlanRequest instance) {
      return from((_DeleteServicePlanRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServicePlanRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServicePlanRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      servicePlanId(instance.getServicePlanId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServicePlanRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteServicePlanRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServicePlanRequest DeleteServicePlanRequest}.
     * @return An immutable instance of DeleteServicePlanRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServicePlanRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServicePlanRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      return "Cannot build DeleteServicePlanRequest, some of required attributes are not set " + attributes;
    }
  }
}
