package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the Space Quota Definition resource
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_SpaceQuotaDefinitionEntity"})
public final class SpaceQuotaDefinitionEntity
    extends org.cloudfoundry.client.v2.spacequotadefinitions._SpaceQuotaDefinitionEntity {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final @Nullable Integer memoryLimit;
  private final @Nullable String name;
  private final @Nullable Boolean nonBasicServicesAllowed;
  private final @Nullable String organizationId;
  private final @Nullable String organizationUrl;
  private final @Nullable String spacesUrl;
  private final @Nullable Integer totalReservedRoutePorts;
  private final @Nullable Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final @Nullable Integer totalServices;

  private SpaceQuotaDefinitionEntity(SpaceQuotaDefinitionEntity.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.organizationId = builder.organizationId;
    this.organizationUrl = builder.organizationUrl;
    this.spacesUrl = builder.spacesUrl;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
  }

  /**
   * The application instance limit
   */
  @JsonProperty("app_instance_limit")
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The number of tasks that can be run per app. (-1 represents an unlimited amount)
   */
  @JsonProperty("app_task_limit")
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The instance memory limit
   */
  @JsonProperty("instance_memory_limit")
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @JsonProperty("memory_limit")
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The non basic services allowed
   */
  @JsonProperty("non_basic_services_allowed")
  @Override
  public @Nullable Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The organization url
   */
  @JsonProperty("organization_url")
  @Override
  public @Nullable String getOrganizationUrl() {
    return organizationUrl;
  }

  /**
   * The spaces url
   */
  @JsonProperty("spaces_url")
  @Override
  public @Nullable String getSpacesUrl() {
    return spacesUrl;
  }

  /**
   * How many routes a space can have that use a reserved port. These routes count toward total_routes. (-1 represents an unlimited amount; subject to org quota)
   */
  @JsonProperty("total_reserved_route_ports")
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total routes
   */
  @JsonProperty("total_routes")
  @Override
  public @Nullable Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * How many service keys an organization can have. (-1 represents an unlimited amount)
   */
  @JsonProperty("total_service_keys")
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * The total services
   */
  @JsonProperty("total_services")
  @Override
  public @Nullable Integer getTotalServices() {
    return totalServices;
  }

  /**
   * This instance is equal to all instances of {@code SpaceQuotaDefinitionEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceQuotaDefinitionEntity
        && equalTo((SpaceQuotaDefinitionEntity) another);
  }

  private boolean equalTo(SpaceQuotaDefinitionEntity another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && Objects.equals(name, another.name)
        && Objects.equals(nonBasicServicesAllowed, another.nonBasicServicesAllowed)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(organizationUrl, another.organizationUrl)
        && Objects.equals(spacesUrl, another.spacesUrl)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && Objects.equals(totalRoutes, another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && Objects.equals(totalServices, another.totalServices);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code organizationId}, {@code organizationUrl}, {@code spacesUrl}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationInstanceLimit);
    h = h * 17 + Objects.hashCode(applicationTaskLimit);
    h = h * 17 + Objects.hashCode(instanceMemoryLimit);
    h = h * 17 + Objects.hashCode(memoryLimit);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(nonBasicServicesAllowed);
    h = h * 17 + Objects.hashCode(organizationId);
    h = h * 17 + Objects.hashCode(organizationUrl);
    h = h * 17 + Objects.hashCode(spacesUrl);
    h = h * 17 + Objects.hashCode(totalReservedRoutePorts);
    h = h * 17 + Objects.hashCode(totalRoutes);
    h = h * 17 + Objects.hashCode(totalServiceKeys);
    h = h * 17 + Objects.hashCode(totalServices);
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceQuotaDefinitionEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceQuotaDefinitionEntity{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", organizationId=" + organizationId
        + ", organizationUrl=" + organizationUrl
        + ", spacesUrl=" + spacesUrl
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spacequotadefinitions._SpaceQuotaDefinitionEntity {
    Integer applicationInstanceLimit;
    Integer applicationTaskLimit;
    Integer instanceMemoryLimit;
    Integer memoryLimit;
    String name;
    Boolean nonBasicServicesAllowed;
    String organizationId;
    String organizationUrl;
    String spacesUrl;
    Integer totalReservedRoutePorts;
    Integer totalRoutes;
    Integer totalServiceKeys;
    Integer totalServices;
    @JsonProperty("app_instance_limit")
    public void setApplicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
    }
    @JsonProperty("app_task_limit")
    public void setApplicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
    }
    @JsonProperty("instance_memory_limit")
    public void setInstanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
    }
    @JsonProperty("memory_limit")
    public void setMemoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("non_basic_services_allowed")
    public void setNonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("organization_url")
    public void setOrganizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
    }
    @JsonProperty("spaces_url")
    public void setSpacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
    }
    @JsonProperty("total_reserved_route_ports")
    public void setTotalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
    }
    @JsonProperty("total_routes")
    public void setTotalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
    }
    @JsonProperty("total_service_keys")
    public void setTotalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
    }
    @JsonProperty("total_services")
    public void setTotalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
    }
    @Override
    public Integer getApplicationInstanceLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationTaskLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNonBasicServicesAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpacesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalReservedRoutePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServiceKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServices() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SpaceQuotaDefinitionEntity fromJson(Json json) {
    SpaceQuotaDefinitionEntity.Builder builder = SpaceQuotaDefinitionEntity.builder();
    if (json.applicationInstanceLimit != null) {
      builder.applicationInstanceLimit(json.applicationInstanceLimit);
    }
    if (json.applicationTaskLimit != null) {
      builder.applicationTaskLimit(json.applicationTaskLimit);
    }
    if (json.instanceMemoryLimit != null) {
      builder.instanceMemoryLimit(json.instanceMemoryLimit);
    }
    if (json.memoryLimit != null) {
      builder.memoryLimit(json.memoryLimit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nonBasicServicesAllowed != null) {
      builder.nonBasicServicesAllowed(json.nonBasicServicesAllowed);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.organizationUrl != null) {
      builder.organizationUrl(json.organizationUrl);
    }
    if (json.spacesUrl != null) {
      builder.spacesUrl(json.spacesUrl);
    }
    if (json.totalReservedRoutePorts != null) {
      builder.totalReservedRoutePorts(json.totalReservedRoutePorts);
    }
    if (json.totalRoutes != null) {
      builder.totalRoutes(json.totalRoutes);
    }
    if (json.totalServiceKeys != null) {
      builder.totalServiceKeys(json.totalServiceKeys);
    }
    if (json.totalServices != null) {
      builder.totalServices(json.totalServices);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SpaceQuotaDefinitionEntity SpaceQuotaDefinitionEntity}.
   * @return A new SpaceQuotaDefinitionEntity builder
   */
  public static SpaceQuotaDefinitionEntity.Builder builder() {
    return new SpaceQuotaDefinitionEntity.Builder();
  }

  /**
   * Builds instances of type {@link SpaceQuotaDefinitionEntity SpaceQuotaDefinitionEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private String organizationId;
    private String organizationUrl;
    private String spacesUrl;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceQuotaDefinitionEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceQuotaDefinitionEntity instance) {
      return from((_SpaceQuotaDefinitionEntity) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceQuotaDefinitionEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceQuotaDefinitionEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Boolean nonBasicServicesAllowedValue = instance.getNonBasicServicesAllowed();
      if (nonBasicServicesAllowedValue != null) {
        nonBasicServicesAllowed(nonBasicServicesAllowedValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String organizationUrlValue = instance.getOrganizationUrl();
      if (organizationUrlValue != null) {
        organizationUrl(organizationUrlValue);
      }
      String spacesUrlValue = instance.getSpacesUrl();
      if (spacesUrlValue != null) {
        spacesUrl(spacesUrlValue);
      }
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      Integer totalRoutesValue = instance.getTotalRoutes();
      if (totalRoutesValue != null) {
        totalRoutes(totalRoutesValue);
      }
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      Integer totalServicesValue = instance.getTotalServices();
      if (totalServicesValue != null) {
        totalServices(totalServicesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_instance_limit")
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_task_limit")
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instance_memory_limit")
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_limit")
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("non_basic_services_allowed")
    public final Builder nonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_guid")
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getOrganizationUrl() organizationUrl} attribute.
     * @param organizationUrl The value for organizationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_url")
    public final Builder organizationUrl(@Nullable String organizationUrl) {
      this.organizationUrl = organizationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getSpacesUrl() spacesUrl} attribute.
     * @param spacesUrl The value for spacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spaces_url")
    public final Builder spacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_reserved_route_ports")
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_routes")
    public final Builder totalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_service_keys")
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link _SpaceQuotaDefinitionEntity#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_services")
    public final Builder totalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
      return this;
    }

    /**
     * Builds a new {@link SpaceQuotaDefinitionEntity SpaceQuotaDefinitionEntity}.
     * @return An immutable instance of SpaceQuotaDefinitionEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceQuotaDefinitionEntity build() {
      return new SpaceQuotaDefinitionEntity(this);
    }
  }
}
