package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Space Summary operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetSpaceSummaryRequest"})
public final class GetSpaceSummaryRequest extends org.cloudfoundry.client.v2.spaces._GetSpaceSummaryRequest {
  private final String spaceId;

  private GetSpaceSummaryRequest(GetSpaceSummaryRequest.Builder builder) {
    this.spaceId = builder.spaceId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceSummaryRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceSummaryRequest
        && equalTo((GetSpaceSummaryRequest) another);
  }

  private boolean equalTo(GetSpaceSummaryRequest another) {
    return spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceSummaryRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceSummaryRequest{"
        + "spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link GetSpaceSummaryRequest GetSpaceSummaryRequest}.
   * @return A new GetSpaceSummaryRequest builder
   */
  public static GetSpaceSummaryRequest.Builder builder() {
    return new GetSpaceSummaryRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceSummaryRequest GetSpaceSummaryRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceSummaryRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceSummaryRequest instance) {
      return from((_GetSpaceSummaryRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceSummaryRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceSummaryRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetSpaceSummaryRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetSpaceSummaryRequest GetSpaceSummaryRequest}.
     * @return An immutable instance of GetSpaceSummaryRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceSummaryRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetSpaceSummaryRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build GetSpaceSummaryRequest, some of required attributes are not set " + attributes;
    }
  }
}
