package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity;

/**
 * The entity response payload for User Provided Service Instances
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UserProvidedServiceInstanceEntity"})
public final class UserProvidedServiceInstanceEntity
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._UserProvidedServiceInstanceEntity {
  private final @Nullable String routeServiceUrl;
  private final @Nullable String syslogDrainUrl;
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String name;
  private final @Nullable String routesUrl;
  private final @Nullable String serviceBindingsUrl;
  private final @Nullable String spaceId;
  private final @Nullable String spaceUrl;
  private final @Nullable String type;

  private UserProvidedServiceInstanceEntity(UserProvidedServiceInstanceEntity.Builder builder) {
    this.routeServiceUrl = builder.routeServiceUrl;
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.routesUrl = builder.routesUrl;
    this.serviceBindingsUrl = builder.serviceBindingsUrl;
    this.spaceId = builder.spaceId;
    this.spaceUrl = builder.spaceUrl;
    this.type = builder.type;
  }

  /**
   * URL to which requests for bound routes will be forwarded
   */
  @JsonProperty("route_service_url")
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * The url for the syslog_drain to direct to
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The routes url
   */
  @JsonProperty("routes_url")
  @Override
  public @Nullable String getRoutesUrl() {
    return routesUrl;
  }

  /**
   * The service bindings url
   */
  @JsonProperty("service_bindings_url")
  @Override
  public @Nullable String getServiceBindingsUrl() {
    return serviceBindingsUrl;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space url
   */
  @JsonProperty("space_url")
  @Override
  public @Nullable String getSpaceUrl() {
    return spaceUrl;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code UserProvidedServiceInstanceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserProvidedServiceInstanceEntity
        && equalTo((UserProvidedServiceInstanceEntity) another);
  }

  private boolean equalTo(UserProvidedServiceInstanceEntity another) {
    return Objects.equals(routeServiceUrl, another.routeServiceUrl)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && Objects.equals(credentials, another.credentials)
        && Objects.equals(name, another.name)
        && Objects.equals(routesUrl, another.routesUrl)
        && Objects.equals(serviceBindingsUrl, another.serviceBindingsUrl)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceUrl, another.spaceUrl)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code routeServiceUrl}, {@code syslogDrainUrl}, {@code credentials}, {@code name}, {@code routesUrl}, {@code serviceBindingsUrl}, {@code spaceId}, {@code spaceUrl}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(routeServiceUrl);
    h = h * 17 + Objects.hashCode(syslogDrainUrl);
    h = h * 17 + Objects.hashCode(credentials);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(routesUrl);
    h = h * 17 + Objects.hashCode(serviceBindingsUrl);
    h = h * 17 + Objects.hashCode(spaceId);
    h = h * 17 + Objects.hashCode(spaceUrl);
    h = h * 17 + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code UserProvidedServiceInstanceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserProvidedServiceInstanceEntity{"
        + "routeServiceUrl=" + routeServiceUrl
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", credentials=" + credentials
        + ", name=" + name
        + ", routesUrl=" + routesUrl
        + ", serviceBindingsUrl=" + serviceBindingsUrl
        + ", spaceId=" + spaceId
        + ", spaceUrl=" + spaceUrl
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.userprovidedserviceinstances._UserProvidedServiceInstanceEntity {
    String routeServiceUrl;
    String syslogDrainUrl;
    Map<String, Object> credentials;
    String name;
    String routesUrl;
    String serviceBindingsUrl;
    String spaceId;
    String spaceUrl;
    String type;
    @JsonProperty("route_service_url")
    public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("routes_url")
    public void setRoutesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
    }
    @JsonProperty("service_bindings_url")
    public void setServiceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_url")
    public void setSpaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String getRouteServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBindingsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserProvidedServiceInstanceEntity fromJson(Json json) {
    UserProvidedServiceInstanceEntity.Builder builder = UserProvidedServiceInstanceEntity.builder();
    if (json.routeServiceUrl != null) {
      builder.routeServiceUrl(json.routeServiceUrl);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routesUrl != null) {
      builder.routesUrl(json.routesUrl);
    }
    if (json.serviceBindingsUrl != null) {
      builder.serviceBindingsUrl(json.serviceBindingsUrl);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceUrl != null) {
      builder.spaceUrl(json.spaceUrl);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserProvidedServiceInstanceEntity UserProvidedServiceInstanceEntity}.
   * @return A new UserProvidedServiceInstanceEntity builder
   */
  public static UserProvidedServiceInstanceEntity.Builder builder() {
    return new UserProvidedServiceInstanceEntity.Builder();
  }

  /**
   * Builds instances of type {@link UserProvidedServiceInstanceEntity UserProvidedServiceInstanceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String routeServiceUrl;
    private String syslogDrainUrl;
    private Map<String, Object> credentials = null;
    private String name;
    private String routesUrl;
    private String serviceBindingsUrl;
    private String spaceId;
    private String spaceUrl;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserProvidedServiceInstanceEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserProvidedServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UserProvidedServiceInstanceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserProvidedServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.userprovidedserviceinstances._UserProvidedServiceInstanceEntity) {
        org.cloudfoundry.client.v2.userprovidedserviceinstances._UserProvidedServiceInstanceEntity instance = (org.cloudfoundry.client.v2.userprovidedserviceinstances._UserProvidedServiceInstanceEntity) object;
        String routeServiceUrlValue = instance.getRouteServiceUrl();
        if (routeServiceUrlValue != null) {
          routeServiceUrl(routeServiceUrlValue);
        }
        String syslogDrainUrlValue = instance.getSyslogDrainUrl();
        if (syslogDrainUrlValue != null) {
          syslogDrainUrl(syslogDrainUrlValue);
        }
      }
      if (object instanceof BaseServiceInstanceEntity) {
        BaseServiceInstanceEntity instance = (BaseServiceInstanceEntity) object;
        String spaceUrlValue = instance.getSpaceUrl();
        if (spaceUrlValue != null) {
          spaceUrl(spaceUrlValue);
        }
        String spaceIdValue = instance.getSpaceId();
        if (spaceIdValue != null) {
          spaceId(spaceIdValue);
        }
        Map<String, Object> credentialsValue = instance.getCredentials();
        if (credentialsValue != null) {
          putAllCredentials(credentialsValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String serviceBindingsUrlValue = instance.getServiceBindingsUrl();
        if (serviceBindingsUrlValue != null) {
          serviceBindingsUrl(serviceBindingsUrlValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String routesUrlValue = instance.getRoutesUrl();
        if (routesUrlValue != null) {
          routesUrl(routesUrlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("route_service_url")
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("syslog_drain_url")
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Put one entry to the {@link _UserProvidedServiceInstanceEntity#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _UserProvidedServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UserProvidedServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UserProvidedServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getRoutesUrl() routesUrl} attribute.
     * @param routesUrl The value for routesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routes_url")
    public final Builder routesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getServiceBindingsUrl() serviceBindingsUrl} attribute.
     * @param serviceBindingsUrl The value for serviceBindingsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_bindings_url")
    public final Builder serviceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getSpaceUrl() spaceUrl} attribute.
     * @param spaceUrl The value for spaceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_url")
    public final Builder spaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserProvidedServiceInstanceEntity#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link UserProvidedServiceInstanceEntity UserProvidedServiceInstanceEntity}.
     * @return An immutable instance of UserProvidedServiceInstanceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserProvidedServiceInstanceEntity build() {
      return new UserProvidedServiceInstanceEntity(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
