package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The data for a docker lifecycle
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DockerData"})
public final class DockerData extends org.cloudfoundry.client.v3._DockerData {
  private final @Nullable String image;

  private DockerData(DockerData.Builder builder) {
    this.image = builder.image;
  }

  /**
   * The image
   */
  @JsonProperty("image")
  @Override
  public @Nullable String getImage() {
    return image;
  }

  /**
   * This instance is equal to all instances of {@code DockerData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DockerData
        && equalTo((DockerData) another);
  }

  private boolean equalTo(DockerData another) {
    return Objects.equals(image, another.image);
  }

  /**
   * Computes a hash code from attributes: {@code image}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(image);
    return h;
  }

  /**
   * Prints the immutable value {@code DockerData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DockerData{"
        + "image=" + image
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._DockerData {
    String image;
    @JsonProperty("image")
    public void setImage(@Nullable String image) {
      this.image = image;
    }
    @Override
    public String getImage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DockerData fromJson(Json json) {
    DockerData.Builder builder = DockerData.builder();
    if (json.image != null) {
      builder.image(json.image);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DockerData DockerData}.
   * @return A new DockerData builder
   */
  public static DockerData.Builder builder() {
    return new DockerData.Builder();
  }

  /**
   * Builds instances of type {@link DockerData DockerData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String image;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DockerData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DockerData instance) {
      return from((_DockerData) instance);
    }

    /**
     * Copy abstract value type {@code _DockerData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DockerData instance) {
      Objects.requireNonNull(instance, "instance");
      String imageValue = instance.getImage();
      if (imageValue != null) {
        image(imageValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DockerData#getImage() image} attribute.
     * @param image The value for image (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("image")
    public final Builder image(@Nullable String image) {
      this.image = image;
      return this;
    }

    /**
     * Builds a new {@link DockerData DockerData}.
     * @return An immutable instance of DockerData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DockerData build() {
      return new DockerData(this);
    }
  }
}
