package org.cloudfoundry.routing.v1.routergroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Update Router Group operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateRouterGroupRequest"})
public final class UpdateRouterGroupRequest
    extends org.cloudfoundry.routing.v1.routergroups._UpdateRouterGroupRequest {
  private final String reservablePorts;
  private final String routerGroupId;

  private UpdateRouterGroupRequest(UpdateRouterGroupRequest.Builder builder) {
    this.reservablePorts = builder.reservablePorts;
    this.routerGroupId = builder.routerGroupId;
  }

  /**
   * The reservable ports
   */
  @Override
  public String getReservablePorts() {
    return reservablePorts;
  }

  /**
   * The router group id
   */
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateRouterGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateRouterGroupRequest
        && equalTo((UpdateRouterGroupRequest) another);
  }

  private boolean equalTo(UpdateRouterGroupRequest another) {
    return reservablePorts.equals(another.reservablePorts)
        && routerGroupId.equals(another.routerGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code reservablePorts}, {@code routerGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + reservablePorts.hashCode();
    h = h * 17 + routerGroupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateRouterGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateRouterGroupRequest{"
        + "reservablePorts=" + reservablePorts
        + ", routerGroupId=" + routerGroupId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateRouterGroupRequest UpdateRouterGroupRequest}.
   * @return A new UpdateRouterGroupRequest builder
   */
  public static UpdateRouterGroupRequest.Builder builder() {
    return new UpdateRouterGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateRouterGroupRequest UpdateRouterGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_RESERVABLE_PORTS = 0x1L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x2L;
    private long initBits = 0x3L;

    private String reservablePorts;
    private String routerGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateRouterGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateRouterGroupRequest instance) {
      return from((_UpdateRouterGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateRouterGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateRouterGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      reservablePorts(instance.getReservablePorts());
      routerGroupId(instance.getRouterGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouterGroupRequest#getReservablePorts() reservablePorts} attribute.
     * @param reservablePorts The value for reservablePorts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder reservablePorts(String reservablePorts) {
      this.reservablePorts = Objects.requireNonNull(reservablePorts, "reservablePorts");
      initBits &= ~INIT_BIT_RESERVABLE_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateRouterGroupRequest#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateRouterGroupRequest UpdateRouterGroupRequest}.
     * @return An immutable instance of UpdateRouterGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateRouterGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateRouterGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_RESERVABLE_PORTS) != 0) attributes.add("reservablePorts");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      return "Cannot build UpdateRouterGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
