package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response from the Batch Create Clients request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_BatchChangeSecretResponse"})
public final class BatchChangeSecretResponse extends org.cloudfoundry.uaa.clients._BatchChangeSecretResponse {
  private final List<Client> clients;

  private BatchChangeSecretResponse(BatchChangeSecretResponse.Builder builder) {
    this.clients = createUnmodifiableList(true, builder.clients);
  }

  /**
   * Clients with changed secrets
   */
  @JsonProperty("clients")
  @Override
  public List<Client> getClients() {
    return clients;
  }

  /**
   * This instance is equal to all instances of {@code BatchChangeSecretResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchChangeSecretResponse
        && equalTo((BatchChangeSecretResponse) another);
  }

  private boolean equalTo(BatchChangeSecretResponse another) {
    return clients.equals(another.clients);
  }

  /**
   * Computes a hash code from attributes: {@code clients}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + clients.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchChangeSecretResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchChangeSecretResponse{"
        + "clients=" + clients
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchChangeSecretResponse {
    List<Client> clients = Collections.emptyList();
    @JsonProperty("clients")
    public void setClients(List<Client> clients) {
      this.clients = clients;
    }
    @Override
    public List<Client> getClients() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BatchChangeSecretResponse fromJson(Json json) {
    BatchChangeSecretResponse.Builder builder = BatchChangeSecretResponse.builder();
    if (json.clients != null) {
      builder.addAllClients(json.clients);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BatchChangeSecretResponse BatchChangeSecretResponse}.
   * @return A new BatchChangeSecretResponse builder
   */
  public static BatchChangeSecretResponse.Builder builder() {
    return new BatchChangeSecretResponse.Builder();
  }

  /**
   * Builds instances of type {@link BatchChangeSecretResponse BatchChangeSecretResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<Client> clients = new ArrayList<Client>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchChangeSecretResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchChangeSecretResponse instance) {
      return from((_BatchChangeSecretResponse) instance);
    }

    /**
     * Copy abstract value type {@code _BatchChangeSecretResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BatchChangeSecretResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllClients(instance.getClients());
      return this;
    }

    /**
     * Adds one element to {@link _BatchChangeSecretResponse#getClients() clients} list.
     * @param element A clients element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(Client element) {
      this.clients.add(Objects.requireNonNull(element, "clients element"));
      return this;
    }

    /**
     * Adds elements to {@link _BatchChangeSecretResponse#getClients() clients} list.
     * @param elements An array of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(Client... elements) {
      for (Client element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _BatchChangeSecretResponse#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clients")
    public final Builder clients(Iterable<? extends Client> elements) {
      this.clients.clear();
      return addAllClients(elements);
    }

    /**
     * Adds elements to {@link _BatchChangeSecretResponse#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClients(Iterable<? extends Client> elements) {
      for (Client element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BatchChangeSecretResponse BatchChangeSecretResponse}.
     * @return An immutable instance of BatchChangeSecretResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchChangeSecretResponse build() {
      return new BatchChangeSecretResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
