package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the Batch Delete Clients operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_BatchDeleteClientsRequest"})
public final class BatchDeleteClientsRequest extends org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest {
  private final List<String> clientIds;
  private final @Nullable String identityZoneId;

  private BatchDeleteClientsRequest(BatchDeleteClientsRequest.Builder builder) {
    this.clientIds = createUnmodifiableList(true, builder.clientIds);
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * A list of identifiers of clients to delete
   */
  @JsonProperty("clientIds")
  @JsonIgnore
  @Override
  public List<String> getClientIds() {
    return clientIds;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code BatchDeleteClientsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchDeleteClientsRequest
        && equalTo((BatchDeleteClientsRequest) another);
  }

  private boolean equalTo(BatchDeleteClientsRequest another) {
    return clientIds.equals(another.clientIds)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code clientIds}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + clientIds.hashCode();
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchDeleteClientsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchDeleteClientsRequest{"
        + "clientIds=" + clientIds
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest {
    List<String> clientIds = Collections.emptyList();
    String identityZoneId;
    @JsonProperty("clientIds")
    @JsonIgnore
    public void setClientIds(List<String> clientIds) {
      this.clientIds = clientIds;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @Override
    public List<String> getClientIds() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BatchDeleteClientsRequest fromJson(Json json) {
    BatchDeleteClientsRequest.Builder builder = BatchDeleteClientsRequest.builder();
    if (json.clientIds != null) {
      builder.addAllClientIds(json.clientIds);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    return builder.build();
  }

  private static BatchDeleteClientsRequest validate(BatchDeleteClientsRequest instance) {
    instance.checkClientIds();
    return instance;
  }

  /**
   * Creates a builder for {@link BatchDeleteClientsRequest BatchDeleteClientsRequest}.
   * @return A new BatchDeleteClientsRequest builder
   */
  public static BatchDeleteClientsRequest.Builder builder() {
    return new BatchDeleteClientsRequest.Builder();
  }

  /**
   * Builds instances of type {@link BatchDeleteClientsRequest BatchDeleteClientsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> clientIds = new ArrayList<String>();
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchDeleteClientsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchDeleteClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BatchDeleteClientsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BatchDeleteClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest) {
        org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest instance = (org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest) object;
        addAllClientIds(instance.getClientIds());
      }
    }

    /**
     * Adds one element to {@link _BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param element A clientIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String element) {
      this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param elements An array of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String... elements) {
      for (String element : elements) {
        this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param elements An iterable of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clientIds")
    public final Builder clientIds(Iterable<String> elements) {
      this.clientIds.clear();
      return addAllClientIds(elements);
    }

    /**
     * Adds elements to {@link _BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param elements An iterable of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClientIds(Iterable<String> elements) {
      for (String element : elements) {
        this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _BatchDeleteClientsRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("identityZoneId")
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link BatchDeleteClientsRequest BatchDeleteClientsRequest}.
     * @return An immutable instance of BatchDeleteClientsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchDeleteClientsRequest build() {
      return BatchDeleteClientsRequest.validate(new BatchDeleteClientsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
