package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The resource in the list clients response
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ChangeSecret"})
public final class ChangeSecret extends org.cloudfoundry.uaa.clients._ChangeSecret {
  private final String clientId;
  private final @Nullable String oldSecret;
  private final String secret;

  private ChangeSecret(ChangeSecret.Builder builder) {
    this.clientId = builder.clientId;
    this.oldSecret = builder.oldSecret;
    this.secret = builder.secret;
  }

  /**
   * The client id
   */
  @JsonProperty("clientId")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The old secret
   */
  @JsonProperty("oldSecret")
  @Override
  public @Nullable String getOldSecret() {
    return oldSecret;
  }

  /**
   * The new secret
   */
  @JsonProperty("secret")
  @Override
  public String getSecret() {
    return secret;
  }

  /**
   * This instance is equal to all instances of {@code ChangeSecret} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeSecret
        && equalTo((ChangeSecret) another);
  }

  private boolean equalTo(ChangeSecret another) {
    return clientId.equals(another.clientId)
        && Objects.equals(oldSecret, another.oldSecret)
        && secret.equals(another.secret);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code oldSecret}, {@code secret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + clientId.hashCode();
    h = h * 17 + Objects.hashCode(oldSecret);
    h = h * 17 + secret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeSecret} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeSecret{"
        + "clientId=" + clientId
        + ", oldSecret=" + oldSecret
        + ", secret=" + secret
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._ChangeSecret {
    String clientId;
    String oldSecret;
    String secret;
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("oldSecret")
    public void setOldSecret(@Nullable String oldSecret) {
      this.oldSecret = oldSecret;
    }
    @JsonProperty("secret")
    public void setSecret(String secret) {
      this.secret = secret;
    }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOldSecret() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecret() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ChangeSecret fromJson(Json json) {
    ChangeSecret.Builder builder = ChangeSecret.builder();
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.oldSecret != null) {
      builder.oldSecret(json.oldSecret);
    }
    if (json.secret != null) {
      builder.secret(json.secret);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ChangeSecret ChangeSecret}.
   * @return A new ChangeSecret builder
   */
  public static ChangeSecret.Builder builder() {
    return new ChangeSecret.Builder();
  }

  /**
   * Builds instances of type {@link ChangeSecret ChangeSecret}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_SECRET = 0x2L;
    private long initBits = 0x3L;

    private String clientId;
    private String oldSecret;
    private String secret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractChangeSecret} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChangeSecret instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeSecret} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeSecret instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ChangeSecret} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ChangeSecret instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractChangeSecret) {
        AbstractChangeSecret instance = (AbstractChangeSecret) object;
        String oldSecretValue = instance.getOldSecret();
        if (oldSecretValue != null) {
          oldSecret(oldSecretValue);
        }
        clientId(instance.getClientId());
        secret(instance.getSecret());
      }
    }

    /**
     * Initializes the value for the {@link _ChangeSecret#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clientId")
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeSecret#getOldSecret() oldSecret} attribute.
     * @param oldSecret The value for oldSecret (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("oldSecret")
    public final Builder oldSecret(@Nullable String oldSecret) {
      this.oldSecret = oldSecret;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeSecret#getSecret() secret} attribute.
     * @param secret The value for secret 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("secret")
    public final Builder secret(String secret) {
      this.secret = Objects.requireNonNull(secret, "secret");
      initBits &= ~INIT_BIT_SECRET;
      return this;
    }

    /**
     * Builds a new {@link ChangeSecret ChangeSecret}.
     * @return An immutable instance of ChangeSecret
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeSecret build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeSecret(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_SECRET) != 0) attributes.add("secret");
      return "Cannot build ChangeSecret, some of required attributes are not set " + attributes;
    }
  }
}
