package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.uaa.Metadata;

/**
 * The resource in the list external group mappings response
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ExternalGroupMapping"})
public final class ExternalGroupMapping extends org.cloudfoundry.uaa.groups._ExternalGroupMapping {
  private final Metadata metadata;
  private final List<String> schemas;
  private final String displayName;
  private final String externalGroup;
  private final String groupId;
  private final String origin;

  private ExternalGroupMapping(ExternalGroupMapping.Builder builder) {
    this.metadata = builder.metadata;
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.displayName = builder.displayName;
    this.externalGroup = builder.externalGroup;
    this.groupId = builder.groupId;
    this.origin = builder.origin;
  }

  /**
   * The group's metadata
   */
  @JsonProperty("meta")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The group's schemas
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * The group's displayed name
   */
  @JsonProperty("displayName")
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The identifier for the group in external identity provider that needs to be mapped to internal UAA groups
   */
  @JsonProperty("externalGroup")
  @Override
  public String getExternalGroup() {
    return externalGroup;
  }

  /**
   * The group unique ID
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Unique alias of the identity provider
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * This instance is equal to all instances of {@code ExternalGroupMapping} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ExternalGroupMapping
        && equalTo((ExternalGroupMapping) another);
  }

  private boolean equalTo(ExternalGroupMapping another) {
    return metadata.equals(another.metadata)
        && schemas.equals(another.schemas)
        && displayName.equals(another.displayName)
        && externalGroup.equals(another.externalGroup)
        && groupId.equals(another.groupId)
        && origin.equals(another.origin);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code schemas}, {@code displayName}, {@code externalGroup}, {@code groupId}, {@code origin}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + metadata.hashCode();
    h = h * 17 + schemas.hashCode();
    h = h * 17 + displayName.hashCode();
    h = h * 17 + externalGroup.hashCode();
    h = h * 17 + groupId.hashCode();
    h = h * 17 + origin.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExternalGroupMapping} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExternalGroupMapping{"
        + "metadata=" + metadata
        + ", schemas=" + schemas
        + ", displayName=" + displayName
        + ", externalGroup=" + externalGroup
        + ", groupId=" + groupId
        + ", origin=" + origin
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._ExternalGroupMapping {
    Metadata metadata;
    List<String> schemas = Collections.emptyList();
    String displayName;
    String externalGroup;
    String groupId;
    String origin;
    @JsonProperty("meta")
    public void setMetadata(Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
      this.displayName = displayName;
    }
    @JsonProperty("externalGroup")
    public void setExternalGroup(String externalGroup) {
      this.externalGroup = externalGroup;
    }
    @JsonProperty("groupId")
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public String getDisplayName() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalGroup() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ExternalGroupMapping fromJson(Json json) {
    ExternalGroupMapping.Builder builder = ExternalGroupMapping.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.displayName != null) {
      builder.displayName(json.displayName);
    }
    if (json.externalGroup != null) {
      builder.externalGroup(json.externalGroup);
    }
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ExternalGroupMapping ExternalGroupMapping}.
   * @return A new ExternalGroupMapping builder
   */
  public static ExternalGroupMapping.Builder builder() {
    return new ExternalGroupMapping.Builder();
  }

  /**
   * Builds instances of type {@link ExternalGroupMapping ExternalGroupMapping}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_METADATA = 0x1L;
    private static final long INIT_BIT_DISPLAY_NAME = 0x2L;
    private static final long INIT_BIT_EXTERNAL_GROUP = 0x4L;
    private static final long INIT_BIT_GROUP_ID = 0x8L;
    private static final long INIT_BIT_ORIGIN = 0x10L;
    private long initBits = 0x1fL;

    private Metadata metadata;
    private List<String> schemas = new ArrayList<String>();
    private String displayName;
    private String externalGroup;
    private String groupId;
    private String origin;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.groups.AbstractExternalGroupResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalGroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.groups.AbstractExternalGroupMapping} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalGroupMapping instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExternalGroupMapping} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExternalGroupMapping instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ExternalGroupMapping} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ExternalGroupMapping instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractExternalGroupResource) {
        AbstractExternalGroupResource instance = (AbstractExternalGroupResource) object;
        displayName(instance.getDisplayName());
        externalGroup(instance.getExternalGroup());
        groupId(instance.getGroupId());
        origin(instance.getOrigin());
      }
      if (object instanceof AbstractExternalGroupMapping) {
        AbstractExternalGroupMapping instance = (AbstractExternalGroupMapping) object;
        metadata(instance.getMetadata());
        addAllSchemas(instance.getSchemas());
      }
    }

    /**
     * Initializes the value for the {@link _ExternalGroupMapping#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Adds one element to {@link _ExternalGroupMapping#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link _ExternalGroupMapping#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ExternalGroupMapping#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link _ExternalGroupMapping#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ExternalGroupMapping#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("displayName")
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _ExternalGroupMapping#getExternalGroup() externalGroup} attribute.
     * @param externalGroup The value for externalGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalGroup")
    public final Builder externalGroup(String externalGroup) {
      this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
      initBits &= ~INIT_BIT_EXTERNAL_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link _ExternalGroupMapping#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ExternalGroupMapping#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Builds a new {@link ExternalGroupMapping ExternalGroupMapping}.
     * @return An immutable instance of ExternalGroupMapping
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExternalGroupMapping build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ExternalGroupMapping(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      if ((initBits & INIT_BIT_EXTERNAL_GROUP) != 0) attributes.add("externalGroup");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      return "Cannot build ExternalGroupMapping, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
