package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;

/**
 * The request payload for the update group
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateGroupRequest"})
public final class UpdateGroupRequest extends org.cloudfoundry.uaa.groups._UpdateGroupRequest {
  private final String version;
  private final @Nullable String description;
  private final String displayName;
  private final String groupId;
  private final List<MemberSummary> members;
  private final @Nullable String identityZoneId;

  private UpdateGroupRequest(UpdateGroupRequest.Builder builder) {
    this.version = builder.version;
    this.description = builder.description;
    this.displayName = builder.displayName;
    this.groupId = builder.groupId;
    this.members = createUnmodifiableList(true, builder.members);
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The version
   */
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * Human readable description of the group, displayed e.g. when approving scopes
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The identifier specified upon creation of the group, unique within the identity zone
   */
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The group id
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Array of group members
   */
  @Override
  public List<MemberSummary> getMembers() {
    return members;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateGroupRequest
        && equalTo((UpdateGroupRequest) another);
  }

  private boolean equalTo(UpdateGroupRequest another) {
    return version.equals(another.version)
        && Objects.equals(description, another.description)
        && displayName.equals(another.displayName)
        && groupId.equals(another.groupId)
        && members.equals(another.members)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code description}, {@code displayName}, {@code groupId}, {@code members}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + version.hashCode();
    h = h * 17 + Objects.hashCode(description);
    h = h * 17 + displayName.hashCode();
    h = h * 17 + groupId.hashCode();
    h = h * 17 + members.hashCode();
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateGroupRequest{"
        + "version=" + version
        + ", description=" + description
        + ", displayName=" + displayName
        + ", groupId=" + groupId
        + ", members=" + members
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateGroupRequest UpdateGroupRequest}.
   * @return A new UpdateGroupRequest builder
   */
  public static UpdateGroupRequest.Builder builder() {
    return new UpdateGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateGroupRequest UpdateGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_DISPLAY_NAME = 0x2L;
    private static final long INIT_BIT_GROUP_ID = 0x4L;
    private long initBits = 0x7L;

    private String version;
    private String description;
    private String displayName;
    private String groupId;
    private List<MemberSummary> members = new ArrayList<MemberSummary>();
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.Versioned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Versioned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._UpdateGroupRequest) {
        org.cloudfoundry.uaa.groups._UpdateGroupRequest instance = (org.cloudfoundry.uaa.groups._UpdateGroupRequest) object;
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        if ((bits & 0x1L) == 0) {
          version(instance.getVersion());
          bits |= 0x1L;
        }
        displayName(instance.getDisplayName());
        groupId(instance.getGroupId());
        addAllMembers(instance.getMembers());
      }
      if (object instanceof Versioned) {
        Versioned instance = (Versioned) object;
        if ((bits & 0x1L) == 0) {
          version(instance.getVersion());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link _UpdateGroupRequest#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupRequest#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateGroupRequest#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(MemberSummary element) {
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateGroupRequest#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(MemberSummary... elements) {
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateGroupRequest#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(Iterable<? extends MemberSummary> elements) {
      this.members.clear();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link _UpdateGroupRequest#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateGroupRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link UpdateGroupRequest UpdateGroupRequest}.
     * @return An immutable instance of UpdateGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build UpdateGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
