package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the get identity provider
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetIdentityProviderRequest"})
public final class GetIdentityProviderRequest
    extends org.cloudfoundry.uaa.identityproviders._GetIdentityProviderRequest {
  private final String identityProviderId;
  private final @Nullable String identityZoneId;

  private GetIdentityProviderRequest(GetIdentityProviderRequest.Builder builder) {
    this.identityProviderId = builder.identityProviderId;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The identity provider id
   */
  @Override
  public String getIdentityProviderId() {
    return identityProviderId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code GetIdentityProviderRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetIdentityProviderRequest
        && equalTo((GetIdentityProviderRequest) another);
  }

  private boolean equalTo(GetIdentityProviderRequest another) {
    return identityProviderId.equals(another.identityProviderId)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code identityProviderId}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + identityProviderId.hashCode();
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code GetIdentityProviderRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetIdentityProviderRequest{"
        + "identityProviderId=" + identityProviderId
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link GetIdentityProviderRequest GetIdentityProviderRequest}.
   * @return A new GetIdentityProviderRequest builder
   */
  public static GetIdentityProviderRequest.Builder builder() {
    return new GetIdentityProviderRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetIdentityProviderRequest GetIdentityProviderRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IDENTITY_PROVIDER_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityProviderId;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetIdentityProviderRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetIdentityProviderRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._GetIdentityProviderRequest) {
        org.cloudfoundry.uaa.identityproviders._GetIdentityProviderRequest instance = (org.cloudfoundry.uaa.identityproviders._GetIdentityProviderRequest) object;
        identityProviderId(instance.getIdentityProviderId());
      }
    }

    /**
     * Initializes the value for the {@link _GetIdentityProviderRequest#getIdentityProviderId() identityProviderId} attribute.
     * @param identityProviderId The value for identityProviderId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviderId(String identityProviderId) {
      this.identityProviderId = Objects.requireNonNull(identityProviderId, "identityProviderId");
      initBits &= ~INIT_BIT_IDENTITY_PROVIDER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetIdentityProviderRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link GetIdentityProviderRequest GetIdentityProviderRequest}.
     * @return An immutable instance of GetIdentityProviderRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetIdentityProviderRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetIdentityProviderRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_IDENTITY_PROVIDER_ID) != 0) attributes.add("identityProviderId");
      return "Cannot build GetIdentityProviderRequest, some of required attributes are not set " + attributes;
    }
  }
}
