package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for the identity zone CORS policy
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CorsPolicy"})
public final class CorsPolicy extends org.cloudfoundry.uaa.identityzones._CorsPolicy {
  private final CorsConfiguration defaultConfiguration;
  private final CorsConfiguration xhrConfiguration;

  private CorsPolicy(CorsPolicy.Builder builder) {
    this.defaultConfiguration = builder.defaultConfiguration;
    this.xhrConfiguration = builder.xhrConfiguration;
  }

  /**
   * The default configuration
   */
  @JsonProperty("defaultConfiguration")
  @Override
  public CorsConfiguration getDefaultConfiguration() {
    return defaultConfiguration;
  }

  /**
   * The XHR configuration
   */
  @JsonProperty("xhrConfiguration")
  @Override
  public CorsConfiguration getXhrConfiguration() {
    return xhrConfiguration;
  }

  /**
   * This instance is equal to all instances of {@code CorsPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CorsPolicy
        && equalTo((CorsPolicy) another);
  }

  private boolean equalTo(CorsPolicy another) {
    return defaultConfiguration.equals(another.defaultConfiguration)
        && xhrConfiguration.equals(another.xhrConfiguration);
  }

  /**
   * Computes a hash code from attributes: {@code defaultConfiguration}, {@code xhrConfiguration}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + defaultConfiguration.hashCode();
    h = h * 17 + xhrConfiguration.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CorsPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CorsPolicy{"
        + "defaultConfiguration=" + defaultConfiguration
        + ", xhrConfiguration=" + xhrConfiguration
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._CorsPolicy {
    CorsConfiguration defaultConfiguration;
    CorsConfiguration xhrConfiguration;
    @JsonProperty("defaultConfiguration")
    public void setDefaultConfiguration(CorsConfiguration defaultConfiguration) {
      this.defaultConfiguration = defaultConfiguration;
    }
    @JsonProperty("xhrConfiguration")
    public void setXhrConfiguration(CorsConfiguration xhrConfiguration) {
      this.xhrConfiguration = xhrConfiguration;
    }
    @Override
    public CorsConfiguration getDefaultConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public CorsConfiguration getXhrConfiguration() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CorsPolicy fromJson(Json json) {
    CorsPolicy.Builder builder = CorsPolicy.builder();
    if (json.defaultConfiguration != null) {
      builder.defaultConfiguration(json.defaultConfiguration);
    }
    if (json.xhrConfiguration != null) {
      builder.xhrConfiguration(json.xhrConfiguration);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CorsPolicy CorsPolicy}.
   * @return A new CorsPolicy builder
   */
  public static CorsPolicy.Builder builder() {
    return new CorsPolicy.Builder();
  }

  /**
   * Builds instances of type {@link CorsPolicy CorsPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DEFAULT_CONFIGURATION = 0x1L;
    private static final long INIT_BIT_XHR_CONFIGURATION = 0x2L;
    private long initBits = 0x3L;

    private CorsConfiguration defaultConfiguration;
    private CorsConfiguration xhrConfiguration;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CorsPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CorsPolicy instance) {
      return from((_CorsPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _CorsPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CorsPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      defaultConfiguration(instance.getDefaultConfiguration());
      xhrConfiguration(instance.getXhrConfiguration());
      return this;
    }

    /**
     * Initializes the value for the {@link _CorsPolicy#getDefaultConfiguration() defaultConfiguration} attribute.
     * @param defaultConfiguration The value for defaultConfiguration 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultConfiguration")
    public final Builder defaultConfiguration(CorsConfiguration defaultConfiguration) {
      this.defaultConfiguration = Objects.requireNonNull(defaultConfiguration, "defaultConfiguration");
      initBits &= ~INIT_BIT_DEFAULT_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _CorsPolicy#getXhrConfiguration() xhrConfiguration} attribute.
     * @param xhrConfiguration The value for xhrConfiguration 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("xhrConfiguration")
    public final Builder xhrConfiguration(CorsConfiguration xhrConfiguration) {
      this.xhrConfiguration = Objects.requireNonNull(xhrConfiguration, "xhrConfiguration");
      initBits &= ~INIT_BIT_XHR_CONFIGURATION;
      return this;
    }

    /**
     * Builds a new {@link CorsPolicy CorsPolicy}.
     * @return An immutable instance of CorsPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CorsPolicy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CorsPolicy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DEFAULT_CONFIGURATION) != 0) attributes.add("defaultConfiguration");
      if ((initBits & INIT_BIT_XHR_CONFIGURATION) != 0) attributes.add("xhrConfiguration");
      return "Cannot build CorsPolicy, some of required attributes are not set " + attributes;
    }
  }
}
