package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response from the get token by client credentials operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetTokenByClientCredentialsResponse"})
public final class GetTokenByClientCredentialsResponse
    extends org.cloudfoundry.uaa.tokens._GetTokenByClientCredentialsResponse {
  private final String accessToken;
  private final Integer expiresInSeconds;
  private final String scopes;
  private final String tokenId;
  private final String tokenType;

  private GetTokenByClientCredentialsResponse(GetTokenByClientCredentialsResponse.Builder builder) {
    this.accessToken = builder.accessToken;
    this.expiresInSeconds = builder.expiresInSeconds;
    this.scopes = builder.scopes;
    this.tokenId = builder.tokenId;
    this.tokenType = builder.tokenType;
  }

  /**
   * The access token
   */
  @JsonProperty("access_token")
  @Override
  public String getAccessToken() {
    return accessToken;
  }

  /**
   * The number of seconds until token expiry
   */
  @JsonProperty("expires_in")
  @Override
  public Integer getExpiresInSeconds() {
    return expiresInSeconds;
  }

  /**
   * The space-delimited list of scopes authorized by the user for this client
   */
  @JsonProperty("scope")
  @Override
  public String getScopes() {
    return scopes;
  }

  /**
   * The identifier for this token
   */
  @JsonProperty("jti")
  @Override
  public String getTokenId() {
    return tokenId;
  }

  /**
   * The type of the access token issued
   */
  @JsonProperty("token_type")
  @Override
  public String getTokenType() {
    return tokenType;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByClientCredentialsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByClientCredentialsResponse
        && equalTo((GetTokenByClientCredentialsResponse) another);
  }

  private boolean equalTo(GetTokenByClientCredentialsResponse another) {
    return accessToken.equals(another.accessToken)
        && expiresInSeconds.equals(another.expiresInSeconds)
        && scopes.equals(another.scopes)
        && tokenId.equals(another.tokenId)
        && tokenType.equals(another.tokenType);
  }

  /**
   * Computes a hash code from attributes: {@code accessToken}, {@code expiresInSeconds}, {@code scopes}, {@code tokenId}, {@code tokenType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + accessToken.hashCode();
    h = h * 17 + expiresInSeconds.hashCode();
    h = h * 17 + scopes.hashCode();
    h = h * 17 + tokenId.hashCode();
    h = h * 17 + tokenType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByClientCredentialsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByClientCredentialsResponse{"
        + "accessToken=" + accessToken
        + ", expiresInSeconds=" + expiresInSeconds
        + ", scopes=" + scopes
        + ", tokenId=" + tokenId
        + ", tokenType=" + tokenType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.tokens._GetTokenByClientCredentialsResponse {
    String accessToken;
    Integer expiresInSeconds;
    String scopes;
    String tokenId;
    String tokenType;
    @JsonProperty("access_token")
    public void setAccessToken(String accessToken) {
      this.accessToken = accessToken;
    }
    @JsonProperty("expires_in")
    public void setExpiresInSeconds(Integer expiresInSeconds) {
      this.expiresInSeconds = expiresInSeconds;
    }
    @JsonProperty("scope")
    public void setScopes(String scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("jti")
    public void setTokenId(String tokenId) {
      this.tokenId = tokenId;
    }
    @JsonProperty("token_type")
    public void setTokenType(String tokenType) {
      this.tokenType = tokenType;
    }
    @Override
    public String getAccessToken() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getExpiresInSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetTokenByClientCredentialsResponse fromJson(Json json) {
    GetTokenByClientCredentialsResponse.Builder builder = GetTokenByClientCredentialsResponse.builder();
    if (json.accessToken != null) {
      builder.accessToken(json.accessToken);
    }
    if (json.expiresInSeconds != null) {
      builder.expiresInSeconds(json.expiresInSeconds);
    }
    if (json.scopes != null) {
      builder.scopes(json.scopes);
    }
    if (json.tokenId != null) {
      builder.tokenId(json.tokenId);
    }
    if (json.tokenType != null) {
      builder.tokenType(json.tokenType);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetTokenByClientCredentialsResponse GetTokenByClientCredentialsResponse}.
   * @return A new GetTokenByClientCredentialsResponse builder
   */
  public static GetTokenByClientCredentialsResponse.Builder builder() {
    return new GetTokenByClientCredentialsResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByClientCredentialsResponse GetTokenByClientCredentialsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ACCESS_TOKEN = 0x1L;
    private static final long INIT_BIT_EXPIRES_IN_SECONDS = 0x2L;
    private static final long INIT_BIT_SCOPES = 0x4L;
    private static final long INIT_BIT_TOKEN_ID = 0x8L;
    private static final long INIT_BIT_TOKEN_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private String accessToken;
    private Integer expiresInSeconds;
    private String scopes;
    private String tokenId;
    private String tokenType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.tokens.AbstractToken} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractToken instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByClientCredentialsResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByClientCredentialsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetTokenByClientCredentialsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByClientCredentialsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractToken) {
        AbstractToken instance = (AbstractToken) object;
        scopes(instance.getScopes());
        tokenId(instance.getTokenId());
        accessToken(instance.getAccessToken());
        tokenType(instance.getTokenType());
        expiresInSeconds(instance.getExpiresInSeconds());
      }
    }

    /**
     * Initializes the value for the {@link _GetTokenByClientCredentialsResponse#getAccessToken() accessToken} attribute.
     * @param accessToken The value for accessToken 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access_token")
    public final Builder accessToken(String accessToken) {
      this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
      initBits &= ~INIT_BIT_ACCESS_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByClientCredentialsResponse#getExpiresInSeconds() expiresInSeconds} attribute.
     * @param expiresInSeconds The value for expiresInSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expires_in")
    public final Builder expiresInSeconds(Integer expiresInSeconds) {
      this.expiresInSeconds = Objects.requireNonNull(expiresInSeconds, "expiresInSeconds");
      initBits &= ~INIT_BIT_EXPIRES_IN_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByClientCredentialsResponse#getScopes() scopes} attribute.
     * @param scopes The value for scopes 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scopes(String scopes) {
      this.scopes = Objects.requireNonNull(scopes, "scopes");
      initBits &= ~INIT_BIT_SCOPES;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByClientCredentialsResponse#getTokenId() tokenId} attribute.
     * @param tokenId The value for tokenId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jti")
    public final Builder tokenId(String tokenId) {
      this.tokenId = Objects.requireNonNull(tokenId, "tokenId");
      initBits &= ~INIT_BIT_TOKEN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByClientCredentialsResponse#getTokenType() tokenType} attribute.
     * @param tokenType The value for tokenType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_type")
    public final Builder tokenType(String tokenType) {
      this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
      initBits &= ~INIT_BIT_TOKEN_TYPE;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByClientCredentialsResponse GetTokenByClientCredentialsResponse}.
     * @return An immutable instance of GetTokenByClientCredentialsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByClientCredentialsResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByClientCredentialsResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ACCESS_TOKEN) != 0) attributes.add("accessToken");
      if ((initBits & INIT_BIT_EXPIRES_IN_SECONDS) != 0) attributes.add("expiresInSeconds");
      if ((initBits & INIT_BIT_SCOPES) != 0) attributes.add("scopes");
      if ((initBits & INIT_BIT_TOKEN_ID) != 0) attributes.add("tokenId");
      if ((initBits & INIT_BIT_TOKEN_TYPE) != 0) attributes.add("tokenType");
      return "Cannot build GetTokenByClientCredentialsResponse, some of required attributes are not set " + attributes;
    }
  }
}
