package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the change user password operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ChangeUserPasswordRequest"})
public final class ChangeUserPasswordRequest extends org.cloudfoundry.uaa.users._ChangeUserPasswordRequest {
  private final String oldPassword;
  private final String password;
  private final String userId;

  private ChangeUserPasswordRequest(ChangeUserPasswordRequest.Builder builder) {
    this.oldPassword = builder.oldPassword;
    this.password = builder.password;
    this.userId = builder.userId;
  }

  /**
   * The user's existing password
   */
  @Override
  public String getOldPassword() {
    return oldPassword;
  }

  /**
   * The user's desired password
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code ChangeUserPasswordRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeUserPasswordRequest
        && equalTo((ChangeUserPasswordRequest) another);
  }

  private boolean equalTo(ChangeUserPasswordRequest another) {
    return oldPassword.equals(another.oldPassword)
        && password.equals(another.password)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code oldPassword}, {@code password}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + oldPassword.hashCode();
    h = h * 17 + password.hashCode();
    h = h * 17 + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeUserPasswordRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeUserPasswordRequest{"
        + "oldPassword=" + oldPassword
        + ", password=" + password
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link ChangeUserPasswordRequest ChangeUserPasswordRequest}.
   * @return A new ChangeUserPasswordRequest builder
   */
  public static ChangeUserPasswordRequest.Builder builder() {
    return new ChangeUserPasswordRequest.Builder();
  }

  /**
   * Builds instances of type {@link ChangeUserPasswordRequest ChangeUserPasswordRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_OLD_PASSWORD = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private static final long INIT_BIT_USER_ID = 0x4L;
    private long initBits = 0x7L;

    private String oldPassword;
    private String password;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeUserPasswordRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeUserPasswordRequest instance) {
      return from((_ChangeUserPasswordRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ChangeUserPasswordRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ChangeUserPasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      oldPassword(instance.getOldPassword());
      password(instance.getPassword());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getOldPassword() oldPassword} attribute.
     * @param oldPassword The value for oldPassword 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oldPassword(String oldPassword) {
      this.oldPassword = Objects.requireNonNull(oldPassword, "oldPassword");
      initBits &= ~INIT_BIT_OLD_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link ChangeUserPasswordRequest ChangeUserPasswordRequest}.
     * @return An immutable instance of ChangeUserPasswordRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeUserPasswordRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeUserPasswordRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_OLD_PASSWORD) != 0) attributes.add("oldPassword");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ChangeUserPasswordRequest, some of required attributes are not set " + attributes;
    }
  }
}
