package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response from the change user password request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ChangeUserPasswordResponse"})
public final class ChangeUserPasswordResponse extends org.cloudfoundry.uaa.users._ChangeUserPasswordResponse {
  private final String message;
  private final String status;

  private ChangeUserPasswordResponse(ChangeUserPasswordResponse.Builder builder) {
    this.message = builder.message;
    this.status = builder.status;
  }

  /**
   * The update message
   */
  @JsonProperty("message")
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * The update status
   */
  @JsonProperty("status")
  @Override
  public String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code ChangeUserPasswordResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeUserPasswordResponse
        && equalTo((ChangeUserPasswordResponse) another);
  }

  private boolean equalTo(ChangeUserPasswordResponse another) {
    return message.equals(another.message)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + message.hashCode();
    h = h * 17 + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeUserPasswordResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeUserPasswordResponse{"
        + "message=" + message
        + ", status=" + status
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._ChangeUserPasswordResponse {
    String message;
    String status;
    @JsonProperty("message")
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty("status")
    public void setStatus(String status) {
      this.status = status;
    }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ChangeUserPasswordResponse fromJson(Json json) {
    ChangeUserPasswordResponse.Builder builder = ChangeUserPasswordResponse.builder();
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ChangeUserPasswordResponse ChangeUserPasswordResponse}.
   * @return A new ChangeUserPasswordResponse builder
   */
  public static ChangeUserPasswordResponse.Builder builder() {
    return new ChangeUserPasswordResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChangeUserPasswordResponse ChangeUserPasswordResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private long initBits = 0x3L;

    private String message;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeUserPasswordResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeUserPasswordResponse instance) {
      return from((_ChangeUserPasswordResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ChangeUserPasswordResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ChangeUserPasswordResponse instance) {
      Objects.requireNonNull(instance, "instance");
      message(instance.getMessage());
      status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordResponse#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordResponse#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(String status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ChangeUserPasswordResponse ChangeUserPasswordResponse}.
     * @return An immutable instance of ChangeUserPasswordResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeUserPasswordResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeUserPasswordResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build ChangeUserPasswordResponse, some of required attributes are not set " + attributes;
    }
  }
}
