package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The metadata payload for a user
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Meta"})
public final class Meta extends org.cloudfoundry.uaa.users._Meta {
  private final String created;
  private final String lastModified;
  private final Integer version;

  private Meta(Meta.Builder builder) {
    this.created = builder.created;
    this.lastModified = builder.lastModified;
    this.version = builder.version;
  }

  /**
   * When the user record was created
   */
  @JsonProperty("created")
  @Override
  public String getCreated() {
    return created;
  }

  /**
   * When the user record was last modified
   */
  @JsonProperty("lastModified")
  @Override
  public String getLastModified() {
    return lastModified;
  }

  /**
   * The metadata version
   */
  @JsonProperty("version")
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code Meta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Meta
        && equalTo((Meta) another);
  }

  private boolean equalTo(Meta another) {
    return created.equals(another.created)
        && lastModified.equals(another.lastModified)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code created}, {@code lastModified}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + created.hashCode();
    h = h * 17 + lastModified.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Meta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Meta{"
        + "created=" + created
        + ", lastModified=" + lastModified
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._Meta {
    String created;
    String lastModified;
    Integer version;
    @JsonProperty("created")
    public void setCreated(String created) {
      this.created = created;
    }
    @JsonProperty("lastModified")
    public void setLastModified(String lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @Override
    public String getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public String getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Meta fromJson(Json json) {
    Meta.Builder builder = Meta.builder();
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Meta Meta}.
   * @return A new Meta builder
   */
  public static Meta.Builder builder() {
    return new Meta.Builder();
  }

  /**
   * Builds instances of type {@link Meta Meta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CREATED = 0x1L;
    private static final long INIT_BIT_LAST_MODIFIED = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private long initBits = 0x7L;

    private String created;
    private String lastModified;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Meta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Meta instance) {
      return from((_Meta) instance);
    }

    /**
     * Copy abstract value type {@code _Meta} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Meta instance) {
      Objects.requireNonNull(instance, "instance");
      created(instance.getCreated());
      lastModified(instance.getLastModified());
      version(instance.getVersion());
      return this;
    }

    /**
     * Initializes the value for the {@link _Meta#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(String created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link _Meta#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastModified")
    public final Builder lastModified(String lastModified) {
      this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
      initBits &= ~INIT_BIT_LAST_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link _Meta#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link Meta Meta}.
     * @return An immutable instance of Meta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Meta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Meta(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_LAST_MODIFIED) != 0) attributes.add("lastModified");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build Meta, some of required attributes are not set " + attributes;
    }
  }
}
