/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.domains._CreateDomainRequest;

public final class CreateDomainRequest
extends _CreateDomainRequest {
    private final String name;
    @Nullable
    private final String owningOrganizationId;
    private final Boolean wildcard;

    private CreateDomainRequest(Builder builder) {
        this.name = builder.name;
        this.owningOrganizationId = builder.owningOrganizationId;
        this.wildcard = builder.wildcard;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    @Override
    public Boolean getWildcard() {
        return this.wildcard;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateDomainRequest && this.equalTo((CreateDomainRequest)another);
    }

    private boolean equalTo(CreateDomainRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.owningOrganizationId, another.owningOrganizationId) && this.wildcard.equals(another.wildcard);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.owningOrganizationId);
        h += (h << 5) + this.wildcard.hashCode();
        return h;
    }

    public String toString() {
        return "CreateDomainRequest{name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ", wildcard=" + this.wildcard + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_WILDCARD = 2L;
        private long initBits = 3L;
        private String name;
        private String owningOrganizationId;
        private Boolean wildcard;

        private Builder() {
        }

        public final Builder from(CreateDomainRequest instance) {
            return this.from((_CreateDomainRequest)instance);
        }

        final Builder from(_CreateDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String owningOrganizationIdValue = instance.getOwningOrganizationId();
            if (owningOrganizationIdValue != null) {
                this.owningOrganizationId(owningOrganizationIdValue);
            }
            this.wildcard(instance.getWildcard());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder owningOrganizationId(@Nullable String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        public final Builder wildcard(Boolean wildcard) {
            this.wildcard = Objects.requireNonNull(wildcard, "wildcard");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("wildcard");
            }
            return "Cannot build CreateDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

