/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.environmentvariablegroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v2.environmentvariablegroups._UpdateRunningEnvironmentVariablesResponse;

public final class UpdateRunningEnvironmentVariablesResponse
extends _UpdateRunningEnvironmentVariablesResponse {
    private final Map<String, Object> environmentVariables;

    private UpdateRunningEnvironmentVariablesResponse(Builder builder) {
        this.environmentVariables = UpdateRunningEnvironmentVariablesResponse.createUnmodifiableMap(false, false, builder.environmentVariables);
    }

    @Override
    @JsonProperty(value="environmentVariables")
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateRunningEnvironmentVariablesResponse && this.equalTo((UpdateRunningEnvironmentVariablesResponse)another);
    }

    private boolean equalTo(UpdateRunningEnvironmentVariablesResponse another) {
        return this.environmentVariables.equals(another.environmentVariables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.environmentVariables.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateRunningEnvironmentVariablesResponse{environmentVariables=" + this.environmentVariables + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateRunningEnvironmentVariablesResponse fromJson(Json json) {
        Builder builder = UpdateRunningEnvironmentVariablesResponse.builder();
        if (json.environmentVariables != null) {
            builder.putAllEnvironmentVariables(json.environmentVariables);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, Object> environmentVariables = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(UpdateRunningEnvironmentVariablesResponse instance) {
            return this.from((_UpdateRunningEnvironmentVariablesResponse)instance);
        }

        final Builder from(_UpdateRunningEnvironmentVariablesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllEnvironmentVariables(instance.getEnvironmentVariables());
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        @JsonProperty(value="environmentVariables")
        public final Builder environmentVariables(Map<String, ? extends Object> environmentVariables) {
            this.environmentVariables.clear();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public UpdateRunningEnvironmentVariablesResponse build() {
            return new UpdateRunningEnvironmentVariablesResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _UpdateRunningEnvironmentVariablesResponse {
        Map<String, Object> environmentVariables = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="environmentVariables")
        public void setEnvironmentVariables(Map<String, Object> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @Override
        public Map<String, Object> getEnvironmentVariables() {
            throw new UnsupportedOperationException();
        }
    }
}

