/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizations._OrganizationSpaceSummary;

public final class OrganizationSpaceSummary
extends _OrganizationSpaceSummary {
    @Nullable
    private final Integer applicationCount;
    @Nullable
    private final String id;
    @Nullable
    private final Integer memoryDevelopmentTotal;
    @Nullable
    private final Integer memoryProductionTotal;
    @Nullable
    private final String name;
    @Nullable
    private final Integer serviceCount;

    private OrganizationSpaceSummary(Builder builder) {
        this.applicationCount = builder.applicationCount;
        this.id = builder.id;
        this.memoryDevelopmentTotal = builder.memoryDevelopmentTotal;
        this.memoryProductionTotal = builder.memoryProductionTotal;
        this.name = builder.name;
        this.serviceCount = builder.serviceCount;
    }

    @Override
    @JsonProperty(value="app_count")
    @Nullable
    public Integer getApplicationCount() {
        return this.applicationCount;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="mem_dev_total")
    @Nullable
    public Integer getMemoryDevelopmentTotal() {
        return this.memoryDevelopmentTotal;
    }

    @Override
    @JsonProperty(value="mem_prod_total")
    @Nullable
    public Integer getMemoryProductionTotal() {
        return this.memoryProductionTotal;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="service_count")
    @Nullable
    public Integer getServiceCount() {
        return this.serviceCount;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OrganizationSpaceSummary && this.equalTo((OrganizationSpaceSummary)another);
    }

    private boolean equalTo(OrganizationSpaceSummary another) {
        return Objects.equals(this.applicationCount, another.applicationCount) && Objects.equals(this.id, another.id) && Objects.equals(this.memoryDevelopmentTotal, another.memoryDevelopmentTotal) && Objects.equals(this.memoryProductionTotal, another.memoryProductionTotal) && Objects.equals(this.name, another.name) && Objects.equals(this.serviceCount, another.serviceCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationCount);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.memoryDevelopmentTotal);
        h += (h << 5) + Objects.hashCode(this.memoryProductionTotal);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.serviceCount);
        return h;
    }

    public String toString() {
        return "OrganizationSpaceSummary{applicationCount=" + this.applicationCount + ", id=" + this.id + ", memoryDevelopmentTotal=" + this.memoryDevelopmentTotal + ", memoryProductionTotal=" + this.memoryProductionTotal + ", name=" + this.name + ", serviceCount=" + this.serviceCount + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static OrganizationSpaceSummary fromJson(Json json) {
        Builder builder = OrganizationSpaceSummary.builder();
        if (json.applicationCount != null) {
            builder.applicationCount(json.applicationCount);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.memoryDevelopmentTotal != null) {
            builder.memoryDevelopmentTotal(json.memoryDevelopmentTotal);
        }
        if (json.memoryProductionTotal != null) {
            builder.memoryProductionTotal(json.memoryProductionTotal);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.serviceCount != null) {
            builder.serviceCount(json.serviceCount);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer applicationCount;
        private String id;
        private Integer memoryDevelopmentTotal;
        private Integer memoryProductionTotal;
        private String name;
        private Integer serviceCount;

        private Builder() {
        }

        public final Builder from(OrganizationSpaceSummary instance) {
            return this.from((_OrganizationSpaceSummary)instance);
        }

        final Builder from(_OrganizationSpaceSummary instance) {
            Integer serviceCountValue;
            String nameValue;
            Integer memoryProductionTotalValue;
            Integer memoryDevelopmentTotalValue;
            String idValue;
            Objects.requireNonNull(instance, "instance");
            Integer applicationCountValue = instance.getApplicationCount();
            if (applicationCountValue != null) {
                this.applicationCount(applicationCountValue);
            }
            if ((idValue = instance.getId()) != null) {
                this.id(idValue);
            }
            if ((memoryDevelopmentTotalValue = instance.getMemoryDevelopmentTotal()) != null) {
                this.memoryDevelopmentTotal(memoryDevelopmentTotalValue);
            }
            if ((memoryProductionTotalValue = instance.getMemoryProductionTotal()) != null) {
                this.memoryProductionTotal(memoryProductionTotalValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((serviceCountValue = instance.getServiceCount()) != null) {
                this.serviceCount(serviceCountValue);
            }
            return this;
        }

        @JsonProperty(value="app_count")
        public final Builder applicationCount(@Nullable Integer applicationCount) {
            this.applicationCount = applicationCount;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="mem_dev_total")
        public final Builder memoryDevelopmentTotal(@Nullable Integer memoryDevelopmentTotal) {
            this.memoryDevelopmentTotal = memoryDevelopmentTotal;
            return this;
        }

        @JsonProperty(value="mem_prod_total")
        public final Builder memoryProductionTotal(@Nullable Integer memoryProductionTotal) {
            this.memoryProductionTotal = memoryProductionTotal;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="service_count")
        public final Builder serviceCount(@Nullable Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public OrganizationSpaceSummary build() {
            return new OrganizationSpaceSummary(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _OrganizationSpaceSummary {
        Integer applicationCount;
        String id;
        Integer memoryDevelopmentTotal;
        Integer memoryProductionTotal;
        String name;
        Integer serviceCount;

        Json() {
        }

        @JsonProperty(value="app_count")
        public void setApplicationCount(@Nullable Integer applicationCount) {
            this.applicationCount = applicationCount;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="mem_dev_total")
        public void setMemoryDevelopmentTotal(@Nullable Integer memoryDevelopmentTotal) {
            this.memoryDevelopmentTotal = memoryDevelopmentTotal;
        }

        @JsonProperty(value="mem_prod_total")
        public void setMemoryProductionTotal(@Nullable Integer memoryProductionTotal) {
            this.memoryProductionTotal = memoryProductionTotal;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="service_count")
        public void setServiceCount(@Nullable Integer serviceCount) {
            this.serviceCount = serviceCount;
        }

        @Override
        public Integer getApplicationCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryDevelopmentTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryProductionTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getServiceCount() {
            throw new UnsupportedOperationException();
        }
    }
}

