/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.resourcematch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.resourcematch._Resource;

public final class Resource
extends _Resource {
    @Nullable
    private final String hash;
    @Nullable
    private final String mode;
    @Nullable
    private final Integer size;

    private Resource(Builder builder) {
        this.hash = builder.hash;
        this.mode = builder.mode;
        this.size = builder.size;
    }

    @Override
    @JsonProperty(value="sha1")
    @Nullable
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="mode")
    @Nullable
    public String getMode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="size")
    @Nullable
    public Integer getSize() {
        return this.size;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Resource && this.equalTo((Resource)another);
    }

    private boolean equalTo(Resource another) {
        return Objects.equals(this.hash, another.hash) && Objects.equals(this.mode, another.mode) && Objects.equals(this.size, another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.mode);
        h += (h << 5) + Objects.hashCode(this.size);
        return h;
    }

    public String toString() {
        return "Resource{hash=" + this.hash + ", mode=" + this.mode + ", size=" + this.size + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Resource fromJson(Json json) {
        Builder builder = Resource.builder();
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.mode != null) {
            builder.mode(json.mode);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String hash;
        private String mode;
        private Integer size;

        private Builder() {
        }

        public final Builder from(Resource instance) {
            return this.from((_Resource)instance);
        }

        final Builder from(_Resource instance) {
            Integer sizeValue;
            String modeValue;
            Objects.requireNonNull(instance, "instance");
            String hashValue = instance.getHash();
            if (hashValue != null) {
                this.hash(hashValue);
            }
            if ((modeValue = instance.getMode()) != null) {
                this.mode(modeValue);
            }
            if ((sizeValue = instance.getSize()) != null) {
                this.size(sizeValue);
            }
            return this;
        }

        @JsonProperty(value="sha1")
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="mode")
        public final Builder mode(@Nullable String mode) {
            this.mode = mode;
            return this;
        }

        @JsonProperty(value="size")
        public final Builder size(@Nullable Integer size) {
            this.size = size;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Resource {
        String hash;
        String mode;
        Integer size;

        Json() {
        }

        @JsonProperty(value="sha1")
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="mode")
        public void setMode(@Nullable String mode) {
            this.mode = mode;
        }

        @JsonProperty(value="size")
        public void setSize(@Nullable Integer size) {
            this.size = size;
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getSize() {
            throw new UnsupportedOperationException();
        }
    }
}

