/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routes._CreateRouteRequest;

public final class CreateRouteRequest
extends _CreateRouteRequest {
    private final String domainId;
    @Nullable
    private final Boolean generatePort;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;
    private final String spaceId;

    private CreateRouteRequest(Builder builder) {
        this.domainId = builder.domainId;
        this.generatePort = builder.generatePort;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
        this.spaceId = builder.spaceId;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public Boolean getGeneratePort() {
        return this.generatePort;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateRouteRequest && this.equalTo((CreateRouteRequest)another);
    }

    private boolean equalTo(CreateRouteRequest another) {
        return this.domainId.equals(another.domainId) && Objects.equals(this.generatePort, another.generatePort) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && this.spaceId.equals(another.spaceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.domainId.hashCode();
        h += (h << 5) + Objects.hashCode(this.generatePort);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.spaceId.hashCode();
        return h;
    }

    public String toString() {
        return "CreateRouteRequest{domainId=" + this.domainId + ", generatePort=" + this.generatePort + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", spaceId=" + this.spaceId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_ID = 1L;
        private static final long INIT_BIT_SPACE_ID = 2L;
        private long initBits = 3L;
        private String domainId;
        private Boolean generatePort;
        private String host;
        private String path;
        private Integer port;
        private String spaceId;

        private Builder() {
        }

        public final Builder from(CreateRouteRequest instance) {
            return this.from((_CreateRouteRequest)instance);
        }

        final Builder from(_CreateRouteRequest instance) {
            Integer portValue;
            String pathValue;
            String hostValue;
            Objects.requireNonNull(instance, "instance");
            this.domainId(instance.getDomainId());
            Boolean generatePortValue = instance.getGeneratePort();
            if (generatePortValue != null) {
                this.generatePort(generatePortValue);
            }
            if ((hostValue = instance.getHost()) != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            this.spaceId(instance.getSpaceId());
            return this;
        }

        public final Builder domainId(String domainId) {
            this.domainId = Objects.requireNonNull(domainId, "domainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder generatePort(@Nullable Boolean generatePort) {
            this.generatePort = generatePort;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build CreateRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

