/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.routes._RouteExistsRequest;

public final class RouteExistsRequest
extends _RouteExistsRequest {
    private final String domainId;
    @Nullable
    private final String host;
    @Nullable
    private final String path;

    private RouteExistsRequest(Builder builder) {
        this.domainId = builder.domainId;
        this.host = builder.host;
        this.path = builder.path;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RouteExistsRequest && this.equalTo((RouteExistsRequest)another);
    }

    private boolean equalTo(RouteExistsRequest another) {
        return this.domainId.equals(another.domainId) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.domainId.hashCode();
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.path);
        return h;
    }

    public String toString() {
        return "RouteExistsRequest{domainId=" + this.domainId + ", host=" + this.host + ", path=" + this.path + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_ID = 1L;
        private long initBits = 1L;
        private String domainId;
        private String host;
        private String path;

        private Builder() {
        }

        public final Builder from(RouteExistsRequest instance) {
            return this.from((_RouteExistsRequest)instance);
        }

        final Builder from(_RouteExistsRequest instance) {
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.domainId(instance.getDomainId());
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            return this;
        }

        public final Builder domainId(String domainId) {
            this.domainId = Objects.requireNonNull(domainId, "domainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public RouteExistsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RouteExistsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainId");
            }
            return "Cannot build RouteExistsRequest, some of required attributes are not set " + attributes;
        }
    }
}

