/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances._CreateServiceInstanceRequest;

public final class CreateServiceInstanceRequest
extends _CreateServiceInstanceRequest {
    @Nullable
    private final Boolean acceptsIncomplete;
    private final String name;
    @Nullable
    private final Map<String, Object> parameters;
    private final String servicePlanId;
    private final String spaceId;
    @Nullable
    private final List<String> tags;

    private CreateServiceInstanceRequest(Builder builder) {
        this.acceptsIncomplete = builder.acceptsIncomplete;
        this.name = builder.name;
        this.parameters = builder.parameters == null ? null : CreateServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.servicePlanId = builder.servicePlanId;
        this.spaceId = builder.spaceId;
        this.tags = builder.tags == null ? null : CreateServiceInstanceRequest.createUnmodifiableList(true, builder.tags);
    }

    @Override
    @Nullable
    public Boolean getAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceInstanceRequest && this.equalTo((CreateServiceInstanceRequest)another);
    }

    private boolean equalTo(CreateServiceInstanceRequest another) {
        return Objects.equals(this.acceptsIncomplete, another.acceptsIncomplete) && this.name.equals(another.name) && Objects.equals(this.parameters, another.parameters) && this.servicePlanId.equals(another.servicePlanId) && this.spaceId.equals(another.spaceId) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.acceptsIncomplete);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + this.servicePlanId.hashCode();
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "CreateServiceInstanceRequest{acceptsIncomplete=" + this.acceptsIncomplete + ", name=" + this.name + ", parameters=" + this.parameters + ", servicePlanId=" + this.servicePlanId + ", spaceId=" + this.spaceId + ", tags=" + this.tags + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SERVICE_PLAN_ID = 2L;
        private static final long INIT_BIT_SPACE_ID = 4L;
        private long initBits = 7L;
        private Boolean acceptsIncomplete;
        private String name;
        private Map<String, Object> parameters = null;
        private String servicePlanId;
        private String spaceId;
        private List<String> tags = null;

        private Builder() {
        }

        public final Builder from(CreateServiceInstanceRequest instance) {
            return this.from((_CreateServiceInstanceRequest)instance);
        }

        final Builder from(_CreateServiceInstanceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
            if (acceptsIncompleteValue != null) {
                this.acceptsIncomplete(acceptsIncompleteValue);
            }
            this.name(instance.getName());
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            this.servicePlanId(instance.getServicePlanId());
            this.spaceId(instance.getSpaceId());
            List<String> tagsValue = instance.getTags();
            if (tagsValue != null) {
                this.addAllTags(tagsValue);
            }
            return this;
        }

        public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
            if (parameters == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(parameters);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tag(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public CreateServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("servicePlanId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build CreateServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

