/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.serviceinstances._ListServiceInstanceServiceBindingsRequest;

public final class ListServiceInstanceServiceBindingsRequest
extends _ListServiceInstanceServiceBindingsRequest {
    @Nullable
    private final List<String> applicationIds;
    private final String serviceInstanceId;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListServiceInstanceServiceBindingsRequest(Builder builder) {
        this.applicationIds = builder.applicationIds == null ? null : ListServiceInstanceServiceBindingsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.serviceInstanceId = builder.serviceInstanceId;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceInstanceServiceBindingsRequest && this.equalTo((ListServiceInstanceServiceBindingsRequest)another);
    }

    private boolean equalTo(ListServiceInstanceServiceBindingsRequest another) {
        return Objects.equals(this.applicationIds, another.applicationIds) && this.serviceInstanceId.equals(another.serviceInstanceId) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationIds);
        h += (h << 5) + this.serviceInstanceId.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListServiceInstanceServiceBindingsRequest{applicationIds=" + this.applicationIds + ", serviceInstanceId=" + this.serviceInstanceId + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private List<String> applicationIds = null;
        private String serviceInstanceId;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListServiceInstanceServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListServiceInstanceServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceInstanceServiceBindingsRequest) {
                instance = (_ListServiceInstanceServiceBindingsRequest)object;
                this.serviceInstanceId(((_ListServiceInstanceServiceBindingsRequest)instance).getServiceInstanceId());
                List<String> applicationIdsValue = ((_ListServiceInstanceServiceBindingsRequest)instance).getApplicationIds();
                if (applicationIdsValue != null) {
                    this.addAllApplicationIds(applicationIdsValue);
                }
            }
        }

        public final Builder applicationId(String element) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationId(String ... elements) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.applicationIds = null;
                return this;
            }
            this.applicationIds = new ArrayList<String>();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "applicationIds element");
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceInstanceServiceBindingsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListServiceInstanceServiceBindingsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build ListServiceInstanceServiceBindingsRequest, some of required attributes are not set " + attributes;
        }
    }
}

