/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.spacequotadefinitions._CreateSpaceQuotaDefinitionRequest;

public final class CreateSpaceQuotaDefinitionRequest
extends _CreateSpaceQuotaDefinitionRequest {
    @Nullable
    private final Integer applicationInstanceLimit;
    @Nullable
    private final Integer applicationTaskLimit;
    @Nullable
    private final Integer instanceMemoryLimit;
    private final Integer memoryLimit;
    private final String name;
    private final Boolean nonBasicServicesAllowed;
    private final String organizationId;
    @Nullable
    private final Integer totalReservedRoutePorts;
    private final Integer totalRoutes;
    @Nullable
    private final Integer totalServiceKeys;
    private final Integer totalServices;

    private CreateSpaceQuotaDefinitionRequest(Builder builder) {
        this.applicationInstanceLimit = builder.applicationInstanceLimit;
        this.applicationTaskLimit = builder.applicationTaskLimit;
        this.instanceMemoryLimit = builder.instanceMemoryLimit;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
        this.organizationId = builder.organizationId;
        this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
        this.totalRoutes = builder.totalRoutes;
        this.totalServiceKeys = builder.totalServiceKeys;
        this.totalServices = builder.totalServices;
    }

    @Override
    @Nullable
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    @Override
    @Nullable
    public Integer getApplicationTaskLimit() {
        return this.applicationTaskLimit;
    }

    @Override
    @Nullable
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    @Override
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public Integer getTotalReservedRoutePorts() {
        return this.totalReservedRoutePorts;
    }

    @Override
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    @Override
    @Nullable
    public Integer getTotalServiceKeys() {
        return this.totalServiceKeys;
    }

    @Override
    public Integer getTotalServices() {
        return this.totalServices;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSpaceQuotaDefinitionRequest && this.equalTo((CreateSpaceQuotaDefinitionRequest)another);
    }

    private boolean equalTo(CreateSpaceQuotaDefinitionRequest another) {
        return Objects.equals(this.applicationInstanceLimit, another.applicationInstanceLimit) && Objects.equals(this.applicationTaskLimit, another.applicationTaskLimit) && Objects.equals(this.instanceMemoryLimit, another.instanceMemoryLimit) && this.memoryLimit.equals(another.memoryLimit) && this.name.equals(another.name) && this.nonBasicServicesAllowed.equals(another.nonBasicServicesAllowed) && this.organizationId.equals(another.organizationId) && Objects.equals(this.totalReservedRoutePorts, another.totalReservedRoutePorts) && this.totalRoutes.equals(another.totalRoutes) && Objects.equals(this.totalServiceKeys, another.totalServiceKeys) && this.totalServices.equals(another.totalServices);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationInstanceLimit);
        h += (h << 5) + Objects.hashCode(this.applicationTaskLimit);
        h += (h << 5) + Objects.hashCode(this.instanceMemoryLimit);
        h += (h << 5) + this.memoryLimit.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.nonBasicServicesAllowed.hashCode();
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.totalReservedRoutePorts);
        h += (h << 5) + this.totalRoutes.hashCode();
        h += (h << 5) + Objects.hashCode(this.totalServiceKeys);
        h += (h << 5) + this.totalServices.hashCode();
        return h;
    }

    public String toString() {
        return "CreateSpaceQuotaDefinitionRequest{applicationInstanceLimit=" + this.applicationInstanceLimit + ", applicationTaskLimit=" + this.applicationTaskLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", organizationId=" + this.organizationId + ", totalReservedRoutePorts=" + this.totalReservedRoutePorts + ", totalRoutes=" + this.totalRoutes + ", totalServiceKeys=" + this.totalServiceKeys + ", totalServices=" + this.totalServices + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MEMORY_LIMIT = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_NON_BASIC_SERVICES_ALLOWED = 4L;
        private static final long INIT_BIT_ORGANIZATION_ID = 8L;
        private static final long INIT_BIT_TOTAL_ROUTES = 16L;
        private static final long INIT_BIT_TOTAL_SERVICES = 32L;
        private long initBits = 63L;
        private Integer applicationInstanceLimit;
        private Integer applicationTaskLimit;
        private Integer instanceMemoryLimit;
        private Integer memoryLimit;
        private String name;
        private Boolean nonBasicServicesAllowed;
        private String organizationId;
        private Integer totalReservedRoutePorts;
        private Integer totalRoutes;
        private Integer totalServiceKeys;
        private Integer totalServices;

        private Builder() {
        }

        public final Builder from(CreateSpaceQuotaDefinitionRequest instance) {
            return this.from((_CreateSpaceQuotaDefinitionRequest)instance);
        }

        final Builder from(_CreateSpaceQuotaDefinitionRequest instance) {
            Integer instanceMemoryLimitValue;
            Integer applicationTaskLimitValue;
            Objects.requireNonNull(instance, "instance");
            Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
            if (applicationInstanceLimitValue != null) {
                this.applicationInstanceLimit(applicationInstanceLimitValue);
            }
            if ((applicationTaskLimitValue = instance.getApplicationTaskLimit()) != null) {
                this.applicationTaskLimit(applicationTaskLimitValue);
            }
            if ((instanceMemoryLimitValue = instance.getInstanceMemoryLimit()) != null) {
                this.instanceMemoryLimit(instanceMemoryLimitValue);
            }
            this.memoryLimit(instance.getMemoryLimit());
            this.name(instance.getName());
            this.nonBasicServicesAllowed(instance.getNonBasicServicesAllowed());
            this.organizationId(instance.getOrganizationId());
            Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
            if (totalReservedRoutePortsValue != null) {
                this.totalReservedRoutePorts(totalReservedRoutePortsValue);
            }
            this.totalRoutes(instance.getTotalRoutes());
            Integer totalServiceKeysValue = instance.getTotalServiceKeys();
            if (totalServiceKeysValue != null) {
                this.totalServiceKeys(totalServiceKeysValue);
            }
            this.totalServices(instance.getTotalServices());
            return this;
        }

        public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
            this.applicationTaskLimit = applicationTaskLimit;
            return this;
        }

        public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = instanceMemoryLimit;
            return this;
        }

        public final Builder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = Objects.requireNonNull(nonBasicServicesAllowed, "nonBasicServicesAllowed");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
            this.totalReservedRoutePorts = totalReservedRoutePorts;
            return this;
        }

        public final Builder totalRoutes(Integer totalRoutes) {
            this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
            this.totalServiceKeys = totalServiceKeys;
            return this;
        }

        public final Builder totalServices(Integer totalServices) {
            this.totalServices = Objects.requireNonNull(totalServices, "totalServices");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public CreateSpaceQuotaDefinitionRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSpaceQuotaDefinitionRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("memoryLimit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nonBasicServicesAllowed");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("organizationId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("totalRoutes");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("totalServices");
            }
            return "Cannot build CreateSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
        }
    }
}

