/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.users._CreateUserRequest;

public final class CreateUserRequest
extends _CreateUserRequest {
    @Nullable
    private final String defaultSpaceId;
    private final String uaaId;

    private CreateUserRequest(Builder builder) {
        this.defaultSpaceId = builder.defaultSpaceId;
        this.uaaId = builder.uaaId;
    }

    @Override
    @Nullable
    public String getDefaultSpaceId() {
        return this.defaultSpaceId;
    }

    @Override
    public String getUaaId() {
        return this.uaaId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateUserRequest && this.equalTo((CreateUserRequest)another);
    }

    private boolean equalTo(CreateUserRequest another) {
        return Objects.equals(this.defaultSpaceId, another.defaultSpaceId) && this.uaaId.equals(another.uaaId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultSpaceId);
        h += (h << 5) + this.uaaId.hashCode();
        return h;
    }

    public String toString() {
        return "CreateUserRequest{defaultSpaceId=" + this.defaultSpaceId + ", uaaId=" + this.uaaId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_UAA_ID = 1L;
        private long initBits = 1L;
        private String defaultSpaceId;
        private String uaaId;

        private Builder() {
        }

        public final Builder from(CreateUserRequest instance) {
            return this.from((_CreateUserRequest)instance);
        }

        final Builder from(_CreateUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            String defaultSpaceIdValue = instance.getDefaultSpaceId();
            if (defaultSpaceIdValue != null) {
                this.defaultSpaceId(defaultSpaceIdValue);
            }
            this.uaaId(instance.getUaaId());
            return this;
        }

        public final Builder defaultSpaceId(@Nullable String defaultSpaceId) {
            this.defaultSpaceId = defaultSpaceId;
            return this;
        }

        public final Builder uaaId(String uaaId) {
            this.uaaId = Objects.requireNonNull(uaaId, "uaaId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public CreateUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateUserRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("uaaId");
            }
            return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
        }
    }
}

