/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ChecksumType;
import org.cloudfoundry.client.v3._Checksum;

public final class Checksum
extends _Checksum {
    private final ChecksumType type;
    @Nullable
    private final String value;

    private Checksum(Builder builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    @Override
    @JsonProperty(value="type")
    public ChecksumType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="value")
    @Nullable
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Checksum && this.equalTo((Checksum)another);
    }

    private boolean equalTo(Checksum another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "Checksum{type=" + (Object)((Object)this.type) + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Checksum fromJson(Json json) {
        Builder builder = Checksum.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private ChecksumType type;
        private String value;

        private Builder() {
        }

        public final Builder from(Checksum instance) {
            return this.from((_Checksum)instance);
        }

        final Builder from(_Checksum instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            String valueValue = instance.getValue();
            if (valueValue != null) {
                this.value(valueValue);
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(ChecksumType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public Checksum build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Checksum(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Checksum, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Checksum {
        ChecksumType type;
        String value;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(ChecksumType type) {
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@Nullable String value) {
            this.value = value;
        }

        @Override
        public ChecksumType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

