/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.jobs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum JobState {
    COMPLETE("COMPLETE"),
    FAILED("FAILED"),
    PROCESSING("PROCESSING");

    private final String value;

    private JobState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static JobState from(String s) {
        switch (s.toLowerCase()) {
            case "complete": {
                return COMPLETE;
            }
            case "failed": {
                return FAILED;
            }
            case "processing": {
                return PROCESSING;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown job state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

