/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingData;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingRelationships;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingType;
import org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingRequest;

public final class CreateServiceBindingRequest
extends _CreateServiceBindingRequest {
    @Nullable
    private final CreateServiceBindingData data;
    private final ServiceBindingRelationships relationships;
    private final ServiceBindingType type;

    private CreateServiceBindingRequest(Builder builder) {
        this.data = builder.data;
        this.relationships = builder.relationships;
        this.type = builder.type;
    }

    @Override
    @Nullable
    public CreateServiceBindingData getData() {
        return this.data;
    }

    @Override
    public ServiceBindingRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    public ServiceBindingType getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceBindingRequest && this.equalTo((CreateServiceBindingRequest)another);
    }

    private boolean equalTo(CreateServiceBindingRequest another) {
        return Objects.equals(this.data, another.data) && this.relationships.equals(another.relationships) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "CreateServiceBindingRequest{data=" + this.data + ", relationships=" + this.relationships + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIPS = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private CreateServiceBindingData data;
        private ServiceBindingRelationships relationships;
        private ServiceBindingType type;

        private Builder() {
        }

        public final Builder from(CreateServiceBindingRequest instance) {
            return this.from((_CreateServiceBindingRequest)instance);
        }

        final Builder from(_CreateServiceBindingRequest instance) {
            Objects.requireNonNull(instance, "instance");
            CreateServiceBindingData dataValue = instance.getData();
            if (dataValue != null) {
                this.data(dataValue);
            }
            this.relationships(instance.getRelationships());
            this.type(instance.getType());
            return this;
        }

        public final Builder data(@Nullable CreateServiceBindingData data) {
            this.data = data;
            return this;
        }

        public final Builder relationships(ServiceBindingRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(ServiceBindingType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateServiceBindingRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServiceBindingRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreateServiceBindingRequest, some of required attributes are not set " + attributes;
        }
    }
}

