/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.servicebindings.ServiceBinding;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingData;
import org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse;

public final class GetServiceBindingResponse
extends _GetServiceBindingResponse {
    @Nullable
    private final String createdAt;
    @Nullable
    private final ServiceBindingData data;
    @Nullable
    private final String id;
    @Nullable
    private final Map<String, Link> links;
    @Nullable
    private final String type;
    @Nullable
    private final String updatedAt;

    private GetServiceBindingResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.data = builder.data;
        this.id = builder.id;
        this.links = builder.links == null ? null : GetServiceBindingResponse.createUnmodifiableMap(false, false, builder.links);
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="data")
    @Nullable
    public ServiceBindingData getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetServiceBindingResponse && this.equalTo((GetServiceBindingResponse)another);
    }

    private boolean equalTo(GetServiceBindingResponse another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.data, another.data) && Objects.equals(this.id, another.id) && Objects.equals(this.links, another.links) && Objects.equals(this.type, another.type) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.links);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "GetServiceBindingResponse{createdAt=" + this.createdAt + ", data=" + this.data + ", id=" + this.id + ", links=" + this.links + ", type=" + this.type + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetServiceBindingResponse fromJson(Json json) {
        Builder builder = GetServiceBindingResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String createdAt;
        private ServiceBindingData data;
        private String id;
        private Map<String, Link> links = null;
        private String type;
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(ServiceBinding instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetServiceBindingResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetServiceBindingResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof ServiceBinding) {
                String updatedAtValue;
                String typeValue;
                ServiceBindingData dataValue;
                String idValue;
                Map<String, Link> linksValue;
                ServiceBinding instance = (ServiceBinding)object;
                String createdAtValue = instance.getCreatedAt();
                if (createdAtValue != null) {
                    this.createdAt(createdAtValue);
                }
                if ((linksValue = instance.getLinks()) != null) {
                    this.putAllLinks(linksValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((dataValue = instance.getData()) != null) {
                    this.data(dataValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                if ((updatedAtValue = instance.getUpdatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(@Nullable ServiceBindingData data) {
            this.data = data;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder link(String key, Link value) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(@Nullable Map<String, ? extends Link> links) {
            if (links == null) {
                this.links = null;
                return this;
            }
            this.links = new LinkedHashMap<String, Link>();
            return this.putAllLinks(links);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> links) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
                String k = entry.getKey();
                Link v = entry.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public GetServiceBindingResponse build() {
            return new GetServiceBindingResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetServiceBindingResponse {
        String createdAt;
        ServiceBindingData data;
        String id;
        Map<String, Link> links = null;
        String type;
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="data")
        public void setData(@Nullable ServiceBindingData data) {
            this.data = data;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(@Nullable Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceBindingData getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

