/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.authorizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.authorizations.AbstractAuthorizationRequest;
import org.cloudfoundry.uaa.authorizations._AuthorizeByOpenIdWithIdTokenRequest;

public final class AuthorizeByOpenIdWithIdTokenRequest
extends _AuthorizeByOpenIdWithIdTokenRequest {
    private final String clientId;
    @Nullable
    private final String redirectUri;
    @Nullable
    private final List<String> scopes;

    private AuthorizeByOpenIdWithIdTokenRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.redirectUri = builder.redirectUri;
        this.scopes = builder.scopes == null ? null : AuthorizeByOpenIdWithIdTokenRequest.createUnmodifiableList(true, builder.scopes);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuthorizeByOpenIdWithIdTokenRequest && this.equalTo((AuthorizeByOpenIdWithIdTokenRequest)another);
    }

    private boolean equalTo(AuthorizeByOpenIdWithIdTokenRequest another) {
        return this.clientId.equals(another.clientId) && Objects.equals(this.redirectUri, another.redirectUri) && Objects.equals(this.scopes, another.scopes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.redirectUri);
        h += (h << 5) + Objects.hashCode(this.scopes);
        return h;
    }

    public String toString() {
        return "AuthorizeByOpenIdWithIdTokenRequest{clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ", scopes=" + this.scopes + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private String clientId;
        private String redirectUri;
        private List<String> scopes = null;

        private Builder() {
        }

        public final Builder from(AbstractAuthorizationRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AuthorizeByOpenIdWithIdTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_AuthorizeByOpenIdWithIdTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractAuthorizationRequest) {
                AbstractAuthorizationRequest instance = (AbstractAuthorizationRequest)object;
                String redirectUriValue = instance.getRedirectUri();
                if (redirectUriValue != null) {
                    this.redirectUri(redirectUriValue);
                }
                this.clientId(instance.getClientId());
                List<String> scopesValue = instance.getScopes();
                if (scopesValue != null) {
                    this.addAllScopes(scopesValue);
                }
            }
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder redirectUri(@Nullable String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final Builder scope(String element) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scope(String ... elements) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder scopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.scopes = null;
                return this;
            }
            this.scopes = new ArrayList<String>();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "scopes element");
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public AuthorizeByOpenIdWithIdTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AuthorizeByOpenIdWithIdTokenRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build AuthorizeByOpenIdWithIdTokenRequest, some of required attributes are not set " + attributes;
        }
    }
}

