/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;
import org.cloudfoundry.uaa.groups.MemberSummary;
import org.cloudfoundry.uaa.groups._UpdateGroupRequest;

public final class UpdateGroupRequest
extends _UpdateGroupRequest {
    private final String version;
    @Nullable
    private final String description;
    private final String displayName;
    private final String groupId;
    private final List<MemberSummary> members;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private UpdateGroupRequest(Builder builder) {
        this.version = builder.version;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.groupId = builder.groupId;
        this.members = UpdateGroupRequest.createUnmodifiableList(true, builder.members);
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public List<MemberSummary> getMembers() {
        return this.members;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateGroupRequest && this.equalTo((UpdateGroupRequest)another);
    }

    private boolean equalTo(UpdateGroupRequest another) {
        return this.version.equals(another.version) && Objects.equals(this.description, another.description) && this.displayName.equals(another.displayName) && this.groupId.equals(another.groupId) && this.members.equals(another.members) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "UpdateGroupRequest{version=" + this.version + ", description=" + this.description + ", displayName=" + this.displayName + ", groupId=" + this.groupId + ", members=" + this.members + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_DISPLAY_NAME = 2L;
        private static final long INIT_BIT_GROUP_ID = 4L;
        private long initBits = 7L;
        private String version;
        private String description;
        private String displayName;
        private String groupId;
        private List<MemberSummary> members = new ArrayList<MemberSummary>();
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_UpdateGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Versioned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _UpdateGroupRequest) {
                instance = (_UpdateGroupRequest)object;
                String descriptionValue = ((_UpdateGroupRequest)instance).getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((bits & 1L) == 0L) {
                    this.version(((_UpdateGroupRequest)instance).getVersion());
                    bits |= 1L;
                }
                this.displayName(((_UpdateGroupRequest)instance).getDisplayName());
                this.groupId(((_UpdateGroupRequest)instance).getGroupId());
                this.addAllMembers(((_UpdateGroupRequest)instance).getMembers());
            }
            if (object instanceof Versioned) {
                instance = (Versioned)object;
                if ((bits & 1L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 1L;
                }
            }
        }

        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder member(MemberSummary element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder member(MemberSummary ... elements) {
            for (MemberSummary element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        public final Builder members(Iterable<? extends MemberSummary> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
            for (MemberSummary memberSummary : elements) {
                this.members.add(Objects.requireNonNull(memberSummary, "members element"));
            }
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public UpdateGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("displayName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("groupId");
            }
            return "Cannot build UpdateGroupRequest, some of required attributes are not set " + attributes;
        }
    }
}

