/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones.IdentityZoneConfiguration;
import org.cloudfoundry.uaa.identityzones._UpdateIdentityZoneRequest;

public final class UpdateIdentityZoneRequest
extends _UpdateIdentityZoneRequest {
    @Nullable
    private final IdentityZoneConfiguration configuration;
    @Nullable
    private final Long createdAt;
    @Nullable
    private final String description;
    private final String identityZoneId;
    @Nullable
    private final Long lastModified;
    private final String name;
    private final String subdomain;
    @Nullable
    private final Integer version;

    private UpdateIdentityZoneRequest(Builder builder) {
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.identityZoneId = builder.identityZoneId;
        this.lastModified = builder.lastModified;
        this.name = builder.name;
        this.subdomain = builder.subdomain;
        this.version = builder.version;
    }

    @Override
    @Nullable
    public IdentityZoneConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateIdentityZoneRequest && this.equalTo((UpdateIdentityZoneRequest)another);
    }

    private boolean equalTo(UpdateIdentityZoneRequest another) {
        return Objects.equals(this.configuration, another.configuration) && Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.description, another.description) && this.identityZoneId.equals(another.identityZoneId) && Objects.equals(this.lastModified, another.lastModified) && this.name.equals(another.name) && this.subdomain.equals(another.subdomain) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.configuration);
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.identityZoneId.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.subdomain.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return "UpdateIdentityZoneRequest{configuration=" + this.configuration + ", createdAt=" + this.createdAt + ", description=" + this.description + ", identityZoneId=" + this.identityZoneId + ", lastModified=" + this.lastModified + ", name=" + this.name + ", subdomain=" + this.subdomain + ", version=" + this.version + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_IDENTITY_ZONE_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SUBDOMAIN = 4L;
        private long initBits = 7L;
        private IdentityZoneConfiguration configuration;
        private Long createdAt;
        private String description;
        private String identityZoneId;
        private Long lastModified;
        private String name;
        private String subdomain;
        private Integer version;

        private Builder() {
        }

        public final Builder from(UpdateIdentityZoneRequest instance) {
            return this.from((_UpdateIdentityZoneRequest)instance);
        }

        final Builder from(_UpdateIdentityZoneRequest instance) {
            String descriptionValue;
            Long createdAtValue;
            Objects.requireNonNull(instance, "instance");
            IdentityZoneConfiguration configurationValue = instance.getConfiguration();
            if (configurationValue != null) {
                this.configuration(configurationValue);
            }
            if ((createdAtValue = instance.getCreatedAt()) != null) {
                this.createdAt(createdAtValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.description(descriptionValue);
            }
            this.identityZoneId(instance.getIdentityZoneId());
            Long lastModifiedValue = instance.getLastModified();
            if (lastModifiedValue != null) {
                this.lastModified(lastModifiedValue);
            }
            this.name(instance.getName());
            this.subdomain(instance.getSubdomain());
            Integer versionValue = instance.getVersion();
            if (versionValue != null) {
                this.version(versionValue);
            }
            return this;
        }

        public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Builder createdAt(@Nullable Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder identityZoneId(String identityZoneId) {
            this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder lastModified(@Nullable Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder subdomain(String subdomain) {
            this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder version(@Nullable Integer version) {
            this.version = version;
            return this;
        }

        public UpdateIdentityZoneRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateIdentityZoneRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identityZoneId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("subdomain");
            }
            return "Cannot build UpdateIdentityZoneRequest, some of required attributes are not set " + attributes;
        }
    }
}

