/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.serverinformation;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.serverinformation._AutoLoginRequest;

public final class AutoLoginRequest
extends _AutoLoginRequest {
    private final String clientId;
    private final String code;

    private AutoLoginRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.code = builder.code;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoLoginRequest && this.equalTo((AutoLoginRequest)another);
    }

    private boolean equalTo(AutoLoginRequest another) {
        return this.clientId.equals(another.clientId) && this.code.equals(another.code);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.code.hashCode();
        return h;
    }

    public String toString() {
        return "AutoLoginRequest{clientId=" + this.clientId + ", code=" + this.code + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CODE = 2L;
        private long initBits = 3L;
        private String clientId;
        private String code;

        private Builder() {
        }

        public final Builder from(AutoLoginRequest instance) {
            return this.from((_AutoLoginRequest)instance);
        }

        final Builder from(_AutoLoginRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.getClientId());
            this.code(instance.getCode());
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AutoLoginRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AutoLoginRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build AutoLoginRequest, some of required attributes are not set " + attributes;
        }
    }
}

