/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum GrantType {
    AUTHORIZATION_CODE("authorization_code"),
    CLIENT_CREDENTIALS("client_credentials"),
    IMPLICIT("implicit"),
    PASSWORD("password"),
    REFRESH_TOKEN("refresh_token");

    private final String value;

    private GrantType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static GrantType from(String s) {
        switch (s.toLowerCase()) {
            case "authorization_code": {
                return AUTHORIZATION_CODE;
            }
            case "client_credentials": {
                return CLIENT_CREDENTIALS;
            }
            case "implicit": {
                return IMPLICIT;
            }
            case "password": {
                return PASSWORD;
            }
            case "refresh_token": {
                return REFRESH_TOKEN;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown grant type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

