/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.users._Name;

public final class Name
extends _Name {
    @Nullable
    private final String familyName;
    @Nullable
    private final String givenName;

    private Name(Builder builder) {
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
    }

    @Override
    @JsonProperty(value="familyName")
    @Nullable
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    @JsonProperty(value="givenName")
    @Nullable
    public String getGivenName() {
        return this.givenName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Name && this.equalTo((Name)another);
    }

    private boolean equalTo(Name another) {
        return Objects.equals(this.familyName, another.familyName) && Objects.equals(this.givenName, another.givenName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.familyName);
        h += (h << 5) + Objects.hashCode(this.givenName);
        return h;
    }

    public String toString() {
        return "Name{familyName=" + this.familyName + ", givenName=" + this.givenName + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Name fromJson(Json json) {
        Builder builder = Name.builder();
        if (json.familyName != null) {
            builder.familyName(json.familyName);
        }
        if (json.givenName != null) {
            builder.givenName(json.givenName);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String familyName;
        private String givenName;

        private Builder() {
        }

        public final Builder from(Name instance) {
            return this.from((_Name)instance);
        }

        final Builder from(_Name instance) {
            String givenNameValue;
            Objects.requireNonNull(instance, "instance");
            String familyNameValue = instance.getFamilyName();
            if (familyNameValue != null) {
                this.familyName(familyNameValue);
            }
            if ((givenNameValue = instance.getGivenName()) != null) {
                this.givenName(givenNameValue);
            }
            return this;
        }

        @JsonProperty(value="familyName")
        public final Builder familyName(@Nullable String familyName) {
            this.familyName = familyName;
            return this;
        }

        @JsonProperty(value="givenName")
        public final Builder givenName(@Nullable String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Name build() {
            return new Name(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Name {
        String familyName;
        String givenName;

        Json() {
        }

        @JsonProperty(value="familyName")
        public void setFamilyName(@Nullable String familyName) {
            this.familyName = familyName;
        }

        @JsonProperty(value="givenName")
        public void setGivenName(@Nullable String givenName) {
            this.givenName = givenName;
        }

        @Override
        public String getFamilyName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGivenName() {
            throw new UnsupportedOperationException();
        }
    }
}

