/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.util.function.Function;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.util.ResourceUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PaginationUtils {
    private PaginationUtils() {
    }

    public static <U extends PaginatedResponse<?>> Flux<U> requestPages(Function<Integer, Mono<U>> pageSupplier) {
        return pageSupplier.apply(1).flatMap(PaginationUtils.requestAdditionalPages(pageSupplier));
    }

    public static <R extends Resource<?>, U extends PaginatedResponse<R>> Flux<R> requestResources(Function<Integer, Mono<U>> pageSupplier) {
        return PaginationUtils.requestPages(pageSupplier).flatMap(ResourceUtils::getResources);
    }

    private static <U extends PaginatedResponse<?>> Function<U, Flux<U>> requestAdditionalPages(Function<Integer, Mono<U>> pageSupplier) {
        return response -> {
            Integer totalPages = response.getTotalPages();
            if (totalPages == null) {
                throw new IllegalStateException(String.format("Page response (class %s) has no total pages set", response.getClass().getCanonicalName()));
            }
            return Flux.range((int)2, (int)(totalPages - 1)).flatMap(pageSupplier).startWith((Object[])new PaginatedResponse[]{response}).buffer().flatMapIterable(d -> d);
        };
    }
}

