/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class TestObjects {
    private TestObjects() {
    }

    public static <T> T fill(T builder) {
        return TestObjects.fill(builder, Optional.empty());
    }

    public static <T> T fill(T builder, String modifier) {
        return TestObjects.fill(builder, Optional.of(modifier));
    }

    private static boolean buildsRequestType(Class<?> builderType) {
        return TestObjects.getBuiltType(builderType).getName().endsWith("Request");
    }

    private static <T> T fill(T builder, Optional<String> modifier) {
        Class<?> builderType = builder.getClass();
        Assert.assertFalse((String)"Do not fill Request types", (boolean)TestObjects.buildsRequestType(builderType));
        List<Method> builderMethods = TestObjects.getBuilderMethods(builderType);
        Set<String> builtGetters = TestObjects.getBuiltGetters(builderType);
        return (T)TestObjects.getConfigurationMethods(builderType, builderMethods, builtGetters).stream().collect(() -> builder, (b, method) -> ReflectionUtils.invokeMethod((Method)method, (Object)b, (Object[])new Object[]{TestObjects.getConfiguredValue(method, modifier)}), (a, b) -> {});
    }

    private static Method getBuildMethod(Class<?> builderType) {
        return ReflectionUtils.findMethod(builderType, (String)"build");
    }

    private static Method getBuilderMethod(Class<?> builderType) {
        return ReflectionUtils.findMethod(builderType, (String)"builder");
    }

    private static List<Method> getBuilderMethods(Class<?> builderType) {
        return Arrays.asList(ReflectionUtils.getUniqueDeclaredMethods(builderType));
    }

    private static Set<String> getBuiltGetters(Class<?> builderType) {
        Class<?> builtType = TestObjects.getBuiltType(builderType);
        return Arrays.stream(ReflectionUtils.getUniqueDeclaredMethods(builtType)).map(Method::getName).filter(s -> s.startsWith("get")).collect(Collectors.toSet());
    }

    private static Class<?> getBuiltType(Class<?> builderType) {
        return TestObjects.getBuildMethod(builderType).getReturnType();
    }

    private static List<Method> getConfigurationMethods(Class<?> builderType, List<Method> builderMethods, Set<String> builtGetters) {
        return builderMethods.stream().filter(TestObjects::isPublic).filter(method -> TestObjects.returnsBuilder(method, builderType)).filter(TestObjects::hasSingleParameter).filter(method -> TestObjects.hasMatchingGetter(method, builtGetters)).collect(Collectors.toList());
    }

    private static Object getConfiguredBuilder(Method builderMethod, Optional<String> modifier) {
        Object builder = ReflectionUtils.invokeMethod((Method)builderMethod, null);
        Method buildMethod = TestObjects.getBuildMethod(builder.getClass());
        return ReflectionUtils.invokeMethod((Method)buildMethod, (Object)TestObjects.fill(builder, modifier));
    }

    private static Object getConfiguredEnum(Class<?> parameterType) {
        return parameterType.getEnumConstants()[0];
    }

    private static String getConfiguredString(Method method, Optional<String> modifier) {
        return modifier.map(m -> String.format("test-%s%s", m, method.getName())).orElse(String.format("test-%s", method.getName()));
    }

    private static Object getConfiguredValue(Method configurationMethod, Optional<String> modifier) {
        Class<?> parameterType = TestObjects.getParameter(configurationMethod).getType();
        Method builderMethod = TestObjects.getBuilderMethod(parameterType);
        if (builderMethod != null) {
            return TestObjects.getConfiguredBuilder(builderMethod, modifier);
        }
        if (Enum.class.isAssignableFrom(parameterType)) {
            return TestObjects.getConfiguredEnum(parameterType);
        }
        if (parameterType == Boolean.class) {
            return Boolean.TRUE;
        }
        if (parameterType == Collection.class) {
            return Collections.emptyList();
        }
        if (parameterType == Date.class) {
            return new Date(0L);
        }
        if (parameterType == Double.class) {
            return 1.0;
        }
        if (parameterType == Duration.class) {
            return Duration.ofSeconds(15L);
        }
        if (parameterType == Integer.class) {
            return 1;
        }
        if (parameterType == Iterable.class) {
            return Collections.emptyList();
        }
        if (parameterType == List.class) {
            return Collections.emptyList();
        }
        if (parameterType == Long.class) {
            return 1L;
        }
        if (parameterType == Map.class) {
            return Collections.emptyMap();
        }
        if (parameterType == String.class) {
            return TestObjects.getConfiguredString(configurationMethod, modifier);
        }
        throw new IllegalStateException(String.format("Unable to configure %s", configurationMethod));
    }

    private static Parameter getParameter(Method method) {
        return method.getParameters()[0];
    }

    private static boolean hasMatchingGetter(Method method, Set<String> builtGetters) {
        String propertyName = method.getName();
        String candidate = String.format("get%s%s", propertyName.substring(0, 1).toUpperCase(), propertyName.substring(1));
        return builtGetters.contains(candidate);
    }

    private static boolean hasSingleParameter(Method method) {
        return 1 == method.getParameterCount();
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean returnsBuilder(Method method, Class<?> builderType) {
        return builderType == method.getReturnType();
    }
}

