/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.atteo.evo.inflector.English;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.junit.Assert;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.tuple.Tuple2;
import reactor.core.util.Exceptions;
import reactor.core.util.ReactiveStateUtils;

public final class TestSubscriber<T>
implements Subscriber<T> {
    private final Queue<T> actuals = new LinkedList<T>();
    private final Queue<Consumer<T>> expectations = new LinkedList<Consumer<T>>();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private Integer countExpectation;
    private volatile Throwable errorActual;
    private Consumer<? super Throwable> errorExpectation;
    private Consumer<Tuple2<Long, Long>> performanceCallback;
    private Consumer<Subscription> scanningCallback;
    private long startTime;
    private Subscription subscription;

    public TestSubscriber<T> assertCount(Integer expected) {
        this.countExpectation = expected;
        return this;
    }

    public TestSubscriber<T> assertEquals(T expected) {
        this.assertThat(actual -> Assert.assertEquals((Object)expected, (Object)actual));
        return this;
    }

    public TestSubscriber<T> assertError(Class<? extends Throwable> expected, String format, Object ... args) {
        this.errorExpectation = actual -> {
            StringWriter writer = new StringWriter();
            actual.printStackTrace(new PrintWriter(writer));
            Assert.assertEquals((String)String.format("Unexpected error %s", writer.toString()), (Object)expected, actual.getClass());
            if (format != null) {
                Assert.assertEquals((String)"Unexpected exception text", (Object)String.format(format, args), (Object)actual.getMessage());
            }
        };
        return this;
    }

    public TestSubscriber<T> assertErrorMatch(Class<? extends Throwable> expected, String patternString) {
        this.errorExpectation = actual -> {
            Matcher matcher;
            StringWriter writer = new StringWriter();
            actual.printStackTrace(new PrintWriter(writer));
            Assert.assertEquals((String)String.format("Unexpected error %s", writer.toString()), (Object)expected, actual.getClass());
            if (patternString != null && !(matcher = Pattern.compile(patternString).matcher(actual.getMessage())).matches()) {
                Assert.fail((String)String.format("Exception text \"%s\" fails to match pattern \"%s\"", actual.getMessage(), patternString));
            }
        };
        return this;
    }

    public TestSubscriber<T> assertThat(Consumer<T> expectation) {
        this.expectations.add(expectation);
        return this;
    }

    public void onComplete() {
        this.latch.countDown();
    }

    public void onError(Throwable t) {
        Exceptions.throwIfFatal((Throwable)t);
        this.errorActual = t;
        this.latch.countDown();
    }

    public void onNext(T t) {
        this.actuals.add(t);
        if (this.scanningCallback != null) {
            this.scanningCallback.accept(this.subscription);
        }
    }

    public void onSubscribe(Subscription s) {
        this.subscribed.set(true);
        this.subscription = s;
        this.startTime = System.currentTimeMillis();
        s.request(Long.MAX_VALUE);
    }

    public TestSubscriber<T> setPerformanceCallback(Consumer<Tuple2<Long, Long>> performanceCallback) {
        this.performanceCallback = performanceCallback;
        return this;
    }

    public TestSubscriber<T> setPerformanceLoggerName(Supplier<String> name) {
        return this.setPerformanceCallback(TupleUtils.consumer((startTime, finishTime) -> {
            Logger logger = LoggerFactory.getLogger((String)String.format("cloudfoundry-client.performance.%s", name.get()));
            if (logger.isDebugEnabled()) {
                logger.debug("{} ms", (Object)(finishTime - startTime));
            }
        }));
    }

    public TestSubscriber<T> setScanningCallback(Consumer<Subscription> scanningCallback) {
        this.scanningCallback = scanningCallback;
        return this;
    }

    public TestSubscriber<T> setScanningLoggerName(Supplier<String> name) {
        return this.setScanningCallback(subscription -> {
            Logger logger = LoggerFactory.getLogger((String)String.format("cloudfoundry-client.scan.%s", name.get()));
            if (logger.isDebugEnabled()) {
                logger.debug(ReactiveStateUtils.scan((Object)subscription).toString());
            }
        });
    }

    public void verify(Duration duration) throws InterruptedException {
        if (!this.subscribed.get()) {
            throw new IllegalStateException("Subscriber not initialized");
        }
        if (!this.latch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Subscriber timed out");
        }
        if (this.performanceCallback != null) {
            this.performanceCallback.accept((Tuple2<Long, Long>)Tuple2.of((Object)this.startTime, (Object)System.currentTimeMillis()));
        }
        this.verifyError();
        this.verifyCount();
        this.verifyItems();
    }

    private void verifyCount() {
        if (this.countExpectation != null) {
            Assert.assertEquals((String)"Item count expectation not met", (Object)this.countExpectation, (Object)this.actuals.size());
        }
    }

    private void verifyError() {
        if (this.errorActual != null) {
            if (this.errorExpectation == null) {
                throw new AssertionError("Unexpected error", this.errorActual);
            }
            this.errorExpectation.accept(this.errorActual);
            this.errorExpectation = null;
        }
        if (this.errorExpectation != null) {
            Assert.fail((String)"Unexpected completion. Error expectation not met.");
        }
    }

    private void verifyItems() {
        for (Object actual : this.actuals) {
            Consumer expectation = this.expectations.poll();
            if (expectation != null) {
                expectation.accept(actual);
                continue;
            }
            if (this.countExpectation != null) continue;
            Assert.fail((String)String.format("Unexpected item %s", actual));
        }
        if (!this.expectations.isEmpty()) {
            int count = this.expectations.size();
            Assert.fail((String)String.format("Unexpected completion. %d %s not met.", count, English.plural((String)"expectation", (int)count)));
        }
    }
}

