/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.state;

import commonj.sdo.DataObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.cloudgraph.state.RowState;
import org.cloudgraph.state.SequenceGenerator;
import org.cloudgraph.store.key.GraphStatefullColumnKeyFactory;
import org.cloudgraph.store.mapping.DataGraphMapping;
import org.cloudgraph.store.mapping.StoreMapping;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;

public class GraphRow
implements RowState {
    protected byte[] rowKey;
    protected SequenceGenerator sequenceMapping;
    protected DataGraphMapping graphConfig;
    protected GraphStatefullColumnKeyFactory columnKeyFactory;
    protected DataObject rootDataObject;
    private Map<Integer, DataObject> dataObjectMap = new HashMap<Integer, DataObject>();
    public static final String ROOT_TYPE_DELIM = "#";

    private GraphRow() {
    }

    public GraphRow(byte[] rowKey, DataObject rootDataObject) {
        this.rowKey = rowKey;
        this.rootDataObject = rootDataObject;
        int hashCode = this.getHashCode((PlasmaDataObject)this.rootDataObject);
        this.dataObjectMap.put(hashCode, rootDataObject);
        QName rootTypeQname = ((PlasmaType)this.rootDataObject.getType()).getQualifiedName();
        this.graphConfig = StoreMapping.getInstance().getDataGraph(rootTypeQname);
    }

    @Override
    public byte[] getRowKey() {
        return this.rowKey;
    }

    @Override
    public DataGraphMapping getDataGraph() {
        return this.graphConfig;
    }

    @Override
    public SequenceGenerator getSequenceMapping() throws IOException {
        return this.sequenceMapping;
    }

    @Override
    public GraphStatefullColumnKeyFactory getColumnKeyFactory() throws IOException {
        return this.columnKeyFactory;
    }

    @Override
    public DataObject getRootDataObject() {
        return this.rootDataObject;
    }

    @Override
    public PlasmaType getRootType() {
        return (PlasmaType)this.rootDataObject.getType();
    }

    @Override
    public void addDataObject(DataObject dataObject) {
        int hashCode = this.getHashCode((PlasmaDataObject)dataObject);
        if (this.dataObjectMap.get(hashCode) != null) {
            throw new IllegalArgumentException("data object already added, " + dataObject);
        }
        this.dataObjectMap.put(hashCode, dataObject);
    }

    @Override
    public boolean contains(DataObject dataObject) {
        int hashCode = this.getHashCode((PlasmaDataObject)dataObject);
        return this.dataObjectMap.containsKey(hashCode);
    }

    @Override
    public boolean contains(UUID uuid) {
        int hashCode = this.getHashCode(uuid);
        return this.dataObjectMap.containsKey(hashCode);
    }

    @Override
    public DataObject getDataObject(UUID uuid) {
        int hashCode = this.getHashCode(uuid);
        DataObject result = this.dataObjectMap.get(hashCode);
        if (result == null) {
            throw new IllegalArgumentException("data object (" + uuid + ") not found");
        }
        return result;
    }

    @Override
    public boolean contains(Long sequence, PlasmaType type) {
        int hashCode = GraphRow.getHashCode(sequence, type);
        return this.dataObjectMap.containsKey(hashCode);
    }

    @Override
    public DataObject getDataObject(Long sequence, PlasmaType type) {
        int hashCode = GraphRow.getHashCode(sequence, type);
        DataObject result = this.dataObjectMap.get(hashCode);
        if (result == null) {
            throw new IllegalArgumentException("data object (" + sequence + ") not found for sequence/type, " + String.valueOf(sequence) + "/" + type);
        }
        return result;
    }

    @Override
    public void addDataObject(DataObject dataObject, Long sequence, PlasmaType type) {
        int hashCode = GraphRow.getHashCode(sequence, type);
        DataObject result = this.dataObjectMap.get(hashCode);
        if (result != null) {
            throw new IllegalArgumentException("data object (" + sequence + ") already exists for sequence/type, " + String.valueOf(sequence) + "/" + type);
        }
        this.dataObjectMap.put(hashCode, dataObject);
    }

    @Override
    public boolean contains(DataObject dataObject, Long sequence, PlasmaType type) {
        int hashCode = GraphRow.getHashCode(sequence, type);
        return this.dataObjectMap.containsKey(hashCode);
    }

    protected int getHashCode(UUID uuid) {
        return uuid.hashCode();
    }

    protected int getHashCode(PlasmaDataObject dataObject) {
        return dataObject.getUUID().hashCode();
    }

    protected int getHashCode(PlasmaType type, PlasmaProperty property, Long sequence) {
        int result = 1;
        result = 31 * result + type.getQualifiedNameHashCode();
        result = 31 * result + property.getName().hashCode();
        result = 31 * result + sequence.hashCode();
        return result;
    }

    protected int getHashCode(PlasmaDataObject dataObject, PlasmaProperty property) {
        int result = 1;
        result = 31 * result + this.getHashCode(dataObject);
        result = 31 * result + property.getName().hashCode();
        return result;
    }

    protected int getHashCode(PlasmaType type, PlasmaProperty property) {
        if (type == null) {
            throw new IllegalArgumentException("expected arg type");
        }
        if (property == null) {
            throw new IllegalArgumentException("expected arg property");
        }
        int result = 1;
        result = 31 * result + type.getQualifiedNameHashCode();
        result = 31 * result + property.getName().hashCode();
        return result;
    }

    public static int getHashCode(Long sequence, PlasmaType type) {
        int result = 1;
        result = 31 * result + sequence.hashCode();
        result = 31 * result + type.getQualifiedNameHashCode();
        return result;
    }
}

