/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.state;

import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.state.SequenceGenerator;
import org.cloudgraph.state.StateException;
import org.cloudgraph.state.proto.StateModelProto;
import org.plasma.sdo.PlasmaType;

public class ProtoSequenceGenerator
implements SequenceGenerator {
    private static Log log = LogFactory.getLog(ProtoSequenceGenerator.class);
    public static final Charset charset = Charset.forName("UTF-8");
    private boolean updated = false;
    private boolean marshaled = false;
    private StateModelProto.StateModel.Builder model;
    private Map<String, StateModelProto.URI.Builder> uriMap = new HashMap<String, StateModelProto.URI.Builder>();
    private Map<Integer, StateModelProto.TypeEntry.Builder> typeNameMap = new HashMap<Integer, StateModelProto.TypeEntry.Builder>();

    public ProtoSequenceGenerator() {
        this.model = StateModelProto.StateModel.newBuilder();
    }

    public ProtoSequenceGenerator(byte[] state) {
        if (state == null) {
            throw new IllegalArgumentException("expected arg, state");
        }
        this.model = this.fromBytes(state);
        for (StateModelProto.URI.Builder uri : this.model.getUriBuilderList()) {
            if (this.uriMap.containsKey(uri.getName())) {
                throw new StateException("mulitple URI's mapped to name '" + uri.getName() + "'");
            }
            this.uriMap.put(uri.getName(), uri);
            for (StateModelProto.TypeEntry.Builder type : uri.getTypeEntryBuilderList()) {
                type.setUriName(uri.getName());
                int typeHash = this.getTypeHashCode(uri.getName(), type.getName());
                if (this.typeNameMap.containsKey(typeHash)) {
                    throw new StateException("mulitple types mapped to uri/type '" + uri.getName() + "/" + type.getName() + "'");
                }
                this.typeNameMap.put(typeHash, type);
            }
        }
        for (StateModelProto.URI.Builder uri : this.model.getUriBuilderList()) {
            uri.clearTypeEntry();
        }
        this.model.clearUri();
    }

    private int getTypeHashCode(PlasmaType type) {
        return this.getTypeHashCode(this.getUriName(type), this.getTypeName(type));
    }

    private int getTypeHashCode(String uriName, String typeName) {
        int result = 1;
        result = 31 * result + uriName.hashCode();
        result = 31 * typeName.hashCode();
        return result;
    }

    private String getUriName(PlasmaType type) {
        String name = type.getURIPhysicalName();
        if (name == null) {
            log.warn((Object)("no URI physical name available for type, " + type + ", encoding logical URI name - please annotate your model with physical name aliases to facilitate logical/physical name isolation"));
            name = type.getURI();
        }
        return name;
    }

    private String getTypeName(PlasmaType type) {
        String name = type.getPhysicalName();
        if (name == null) {
            log.warn((Object)("no physical name available for type, " + type + ", encoding logical name - please annotate your model with physical name aliases to facilitate logical/physical name isolation"));
            name = type.getName();
        }
        return name;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasLastSequence(PlasmaType type) {
        return this.typeNameMap.containsKey(this.getTypeHashCode(type));
    }

    @Override
    public Long lastSequence(PlasmaType type) {
        StateModelProto.TypeEntry.Builder typeEntry = this.typeNameMap.get(this.getTypeHashCode(type));
        return typeEntry.getSequence();
    }

    @Override
    public Long nextSequence(DataObject dataObject) {
        PlasmaType type = (PlasmaType)dataObject.getType();
        return this.nextSequence(type);
    }

    @Override
    public Long nextSequence(PlasmaType type) {
        String typeName;
        if (this.marshaled) {
            throw new IllegalStateException("protocol has already been marshalled, and cannot be updated");
        }
        String uriName = this.getUriName(type);
        int typeHash = this.getTypeHashCode(uriName, typeName = this.getTypeName(type));
        StateModelProto.TypeEntry.Builder typeEntry = this.typeNameMap.get(typeHash);
        if (typeEntry == null) {
            typeEntry = StateModelProto.TypeEntry.newBuilder();
            typeEntry.setName(typeName);
            typeEntry.setSequence(1L);
            typeEntry.setHashValue(type.getQualifiedNameHashCode());
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding type " + type.getQualifiedName() + " seq: " + typeEntry.getSequence() + " hash: " + typeEntry.getHashValue()));
            }
            this.typeNameMap.put(typeHash, typeEntry);
            StateModelProto.URI.Builder uri = this.uriMap.get(uriName);
            if (uri == null) {
                uri = StateModelProto.URI.newBuilder();
                uri.setName(uriName);
                this.uriMap.put(uriName, uri);
            }
            typeEntry.setUriName(uri.getName());
        } else {
            typeEntry.setSequence(typeEntry.getSequence() + 1L);
        }
        this.updated = true;
        return typeEntry.getSequence();
    }

    @Override
    public String marshalAsString() {
        return new String(this.marshal(), charset);
    }

    @Override
    public String marshalAsString(boolean formatted) {
        return this.marshalAsString();
    }

    @Override
    public byte[] marshal() {
        for (StateModelProto.TypeEntry.Builder type : this.typeNameMap.values()) {
            StateModelProto.URI.Builder uri = this.uriMap.get(type.getUriName());
            uri.addTypeEntry(type);
        }
        for (StateModelProto.URI.Builder uri : this.uriMap.values()) {
            this.model.addUri(uri);
        }
        StateModelProto.StateModel result = this.model.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("marshal: " + result));
        }
        this.marshaled = true;
        return this.toBytes(result);
    }

    private byte[] toBytes(StateModelProto.StateModel model) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            model.writeDelimitedTo(baos);
            baos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new StateException(e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return bytes;
    }

    private StateModelProto.StateModel.Builder fromBytes(byte[] content) {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        try {
            StateModelProto.StateModel.Builder result = StateModelProto.StateModel.newBuilder();
            result.mergeDelimitedFrom(bais);
            StateModelProto.StateModel.Builder builder = result;
            return builder;
        }
        catch (IOException e) {
            throw new StateException(e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return this.model.toString();
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }
}

