/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import commonj.sdo.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudgraph.store.mapping.ColumnKeyField;
import org.cloudgraph.store.mapping.ColumnKeyFieldMapping;
import org.cloudgraph.store.mapping.ColumnKeyModel;
import org.cloudgraph.store.mapping.ConstantField;
import org.cloudgraph.store.mapping.ConstantRowKeyFieldMapping;
import org.cloudgraph.store.mapping.DataField;
import org.cloudgraph.store.mapping.DataGraph;
import org.cloudgraph.store.mapping.DataRowKeyFieldMapping;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.MetaField;
import org.cloudgraph.store.mapping.MetaFieldName;
import org.cloudgraph.store.mapping.MetaKeyFieldMapping;
import org.cloudgraph.store.mapping.Property;
import org.cloudgraph.store.mapping.RowKeyField;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.cloudgraph.store.mapping.TableMapping;
import org.plasma.runtime.ConfigurationException;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class DataGraphMapping {
    private DataGraph graph;
    private TableMapping table;
    private Map<MetaFieldName, MetaKeyFieldMapping> metaRowKeyFieldMap = new HashMap<MetaFieldName, MetaKeyFieldMapping>();
    private List<MetaKeyFieldMapping> metaRowKeyFieldList = new ArrayList<MetaKeyFieldMapping>();
    private Map<MetaFieldName, ColumnKeyFieldMapping> metaColumnKeyFieldMap = new HashMap<MetaFieldName, ColumnKeyFieldMapping>();
    private List<DataRowKeyFieldMapping> dataRowKeyFieldList = new ArrayList<DataRowKeyFieldMapping>();
    private Map<String, DataRowKeyFieldMapping> pathToDataRowKeyMap = new HashMap<String, DataRowKeyFieldMapping>();
    private Map<commonj.sdo.Property, DataRowKeyFieldMapping> propertyToDataRowKeyMap = new HashMap<commonj.sdo.Property, DataRowKeyFieldMapping>();
    private List<ConstantRowKeyFieldMapping> constantRowKeyFieldList = new ArrayList<ConstantRowKeyFieldMapping>();
    private List<KeyFieldMapping> rowKeyFieldList = new ArrayList<KeyFieldMapping>();
    private List<KeyFieldMapping> columnKeyFieldList = new ArrayList<KeyFieldMapping>();
    private Map<String, Property> propertyNameToPropertyMap = new HashMap<String, Property>();
    private byte[] rowKeyFieldDelimiterBytes;
    private byte[] columnKeyFieldDelimiterBytes;
    private byte[] columnKeySequenceDelimiterBytes;
    private byte[] columnKeyReferenceMetadataDelimiterBytes;

    private DataGraphMapping() {
    }

    public DataGraphMapping(DataGraph graph, TableMapping table) {
        this.graph = graph;
        this.table = table;
        try {
            PlasmaRuntime.getInstance().getSDONamespaceByURI(graph.getUri());
        }
        catch (ConfigurationException e) {
            throw new StoreMappingException("invalid graph URI '" + graph.getUri() + "' specified for table, '" + table.getName() + "'", e);
        }
        Type typeResult = PlasmaTypeHelper.INSTANCE.getType(graph.getUri(), graph.getType());
        if (typeResult == null) {
            throw new StoreMappingException("invalid graph URI/type combination '" + graph.getUri() + "/" + graph.getType() + "' specified for table, '" + table.getName() + "' - type does not exist");
        }
        for (Property prop : graph.getProperties()) {
            this.propertyNameToPropertyMap.put(prop.getName(), prop);
        }
        int totalRowKeyFields = this.graph.getRowKeyModel().getRowKeyFields().size();
        int seqNum = 1;
        for (RowKeyField rowKeyField : this.graph.getRowKeyModel().getRowKeyFields()) {
            if (rowKeyField.getMetaField() != null) {
                MetaField predefinedField = rowKeyField.getMetaField();
                MetaKeyFieldMapping predefinedFieldConfig = new MetaKeyFieldMapping(this, predefinedField, seqNum, totalRowKeyFields);
                this.metaRowKeyFieldMap.put(predefinedField.getName(), predefinedFieldConfig);
                this.metaRowKeyFieldList.add(predefinedFieldConfig);
                this.rowKeyFieldList.add(predefinedFieldConfig);
            } else if (rowKeyField.getDataField() != null) {
                DataField userField = rowKeyField.getDataField();
                DataRowKeyFieldMapping userFieldConfig = new DataRowKeyFieldMapping(this, userField, seqNum, totalRowKeyFields);
                this.dataRowKeyFieldList.add(userFieldConfig);
                if (this.pathToDataRowKeyMap.get(userFieldConfig.getPropertyPath()) != null) {
                    throw new StoreMappingException("a user defined token path '" + userFieldConfig.getPathExpression() + "' already exists with property path '" + userFieldConfig.getPropertyPath() + "' for data graph of type, " + this.graph.getUri() + "#" + this.graph.getType());
                }
                this.pathToDataRowKeyMap.put(userFieldConfig.getPropertyPath(), userFieldConfig);
                this.propertyToDataRowKeyMap.put((commonj.sdo.Property)userFieldConfig.getEndpointProperty(), userFieldConfig);
                this.rowKeyFieldList.add(userFieldConfig);
            } else if (rowKeyField.getConstantField() != null) {
                ConstantField constantField = rowKeyField.getConstantField();
                ConstantRowKeyFieldMapping constantFieldConfig = new ConstantRowKeyFieldMapping(this, constantField, seqNum, totalRowKeyFields);
                this.constantRowKeyFieldList.add(constantFieldConfig);
                this.rowKeyFieldList.add(constantFieldConfig);
            } else {
                throw new StoreMappingException("unexpected row key model field instance, " + rowKeyField.getClass().getName());
            }
            ++seqNum;
        }
        ColumnKeyModel columnKeyModel = this.graph.getColumnKeyModel();
        if (columnKeyModel.getReferenceMetadataDelimiter() == null) {
            throw new StoreMappingException("found invalid (null) column metadata delimiter for table, " + this.table.getName() + ", for graph " + this.graph.getUri() + "#" + this.graph.getType());
        }
        if (columnKeyModel.getFieldDelimiter() == null) {
            throw new StoreMappingException("found invalid (null) column field delimiter for table, " + this.table.getName() + ", for graph " + this.graph.getUri() + "#" + this.graph.getType());
        }
        if (columnKeyModel.getSequenceDelimiter() == null) {
            throw new StoreMappingException("found invalid (null) column sequence delimiter for table, " + this.table.getName() + ", for graph " + this.graph.getUri() + "#" + this.graph.getType());
        }
        if (columnKeyModel.getReferenceMetadataDelimiter().equals(columnKeyModel.getFieldDelimiter())) {
            throw new StoreMappingException("found duplicate (" + columnKeyModel.getFieldDelimiter() + ") column metadata delimiter " + "for table, " + this.table.getName() + ", for graph " + this.graph.getUri() + "#" + this.graph.getType());
        }
        if (columnKeyModel.getSequenceDelimiter().equals(columnKeyModel.getFieldDelimiter())) {
            throw new StoreMappingException("found duplicate (" + columnKeyModel.getFieldDelimiter() + ") column sequence delimiter " + "for table, " + this.table.getName() + ", for graph " + this.graph.getUri() + "#" + this.graph.getType());
        }
        if (columnKeyModel.getReferenceMetadataDelimiter().equals(columnKeyModel.getSequenceDelimiter())) {
            throw new StoreMappingException("found duplicate (" + columnKeyModel.getSequenceDelimiter() + ") column metadata delimiter " + "for table, " + this.table.getName() + ", for graph " + this.graph.getUri() + "#" + this.graph.getType());
        }
        int totalColumnKeyFields = columnKeyModel.getColumnKeyFields().size();
        seqNum = 1;
        for (ColumnKeyField ctoken : columnKeyModel.getColumnKeyFields()) {
            ColumnKeyFieldMapping columnFieldConfig = new ColumnKeyFieldMapping(this, ctoken, seqNum, totalColumnKeyFields);
            this.metaColumnKeyFieldMap.put(ctoken.getName(), columnFieldConfig);
            this.columnKeyFieldList.add(columnFieldConfig);
            ++seqNum;
        }
    }

    public DataGraph getGraph() {
        return this.graph;
    }

    public ColumnKeyModel getColumnKeyModel() {
        return this.graph.getColumnKeyModel();
    }

    public Type getRootType() {
        return PlasmaTypeHelper.INSTANCE.getType(this.graph.getUri(), this.graph.getType());
    }

    public List<Property> getProperties() {
        return this.graph.properties;
    }

    public Property findProperty(String name) {
        return this.propertyNameToPropertyMap.get(name);
    }

    public List<MetaKeyFieldMapping> getPreDefinedRowKeyFields() {
        return this.metaRowKeyFieldList;
    }

    public MetaKeyFieldMapping getPreDefinedRowKeyField(MetaFieldName name) {
        return this.metaRowKeyFieldMap.get((Object)name);
    }

    public String getRowKeyFieldDelimiter() {
        return this.graph.getRowKeyModel().getFieldDelimiter();
    }

    public byte[] getRowKeyFieldDelimiterBytes() {
        if (this.rowKeyFieldDelimiterBytes == null) {
            this.rowKeyFieldDelimiterBytes = this.graph.getRowKeyModel().getFieldDelimiter().getBytes(Charset.forName("UTF-8"));
        }
        return this.rowKeyFieldDelimiterBytes;
    }

    public boolean hasUserDefinedRowKeyFields() {
        return this.dataRowKeyFieldList.size() > 0;
    }

    public List<DataRowKeyFieldMapping> getUserDefinedRowKeyFields() {
        return this.dataRowKeyFieldList;
    }

    public DataRowKeyFieldMapping getUserDefinedRowKeyField(String path) {
        return this.pathToDataRowKeyMap.get(path);
    }

    public List<KeyFieldMapping> getRowKeyFields() {
        return this.rowKeyFieldList;
    }

    public List<KeyFieldMapping> getColumnKeyFields() {
        return this.columnKeyFieldList;
    }

    public DataRowKeyFieldMapping findUserDefinedRowKeyField(commonj.sdo.Property property) {
        return this.propertyToDataRowKeyMap.get(property);
    }

    public ColumnKeyFieldMapping getColumnKeyField(MetaFieldName name) {
        return this.metaColumnKeyFieldMap.get((Object)name);
    }

    public String getColumnKeyFieldDelimiter() {
        return this.graph.getColumnKeyModel().getFieldDelimiter();
    }

    public String getColumnKeySequenceDelimiter() {
        return this.graph.getColumnKeyModel().getSequenceDelimiter();
    }

    public byte[] getColumnKeyFieldDelimiterBytes() {
        if (this.columnKeyFieldDelimiterBytes == null) {
            this.columnKeyFieldDelimiterBytes = this.graph.getColumnKeyModel().getFieldDelimiter().getBytes(Charset.forName("UTF-8"));
        }
        return this.columnKeyFieldDelimiterBytes;
    }

    public byte[] getColumnKeySequenceDelimiterBytes() {
        if (this.columnKeySequenceDelimiterBytes == null) {
            this.columnKeySequenceDelimiterBytes = this.graph.getColumnKeyModel().getSequenceDelimiter().getBytes(Charset.forName("UTF-8"));
        }
        return this.columnKeySequenceDelimiterBytes;
    }

    public byte[] getColumnKeyReferenceMetadataDelimiterBytes() {
        if (this.columnKeyReferenceMetadataDelimiterBytes == null) {
            this.columnKeyReferenceMetadataDelimiterBytes = this.graph.getColumnKeyModel().getReferenceMetadataDelimiter().getBytes(Charset.forName("UTF-8"));
        }
        return this.columnKeyReferenceMetadataDelimiterBytes;
    }

    public TableMapping getTable() {
        return this.table;
    }
}

