/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.store.mapping.DataField;
import org.cloudgraph.store.mapping.DataGraphMapping;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.MissingRequiredConstraintException;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.cloudgraph.store.mapping.UnresolvedPathExpressionException;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.ValueConstraint;

public class DataRowKeyFieldMapping
extends KeyFieldMapping {
    private static Log log = LogFactory.getLog(DataRowKeyFieldMapping.class);
    private DataField dataField;
    private String propertyPath;
    private PlasmaProperty endpointProperty;
    private int maxLength;

    public DataRowKeyFieldMapping(DataGraphMapping dataGraph, DataField dataField, int sequenceNum, int totalFields) {
        super(dataGraph, dataField, sequenceNum, totalFields);
        this.dataField = dataField;
        try {
            this.construct(this.dataField.getPath());
        }
        catch (IllegalArgumentException e) {
            throw new StoreMappingException(e);
        }
    }

    private void construct(String xpath) {
        Type contextType = this.getDataGraph().getRootType();
        StringBuilder buf = new StringBuilder();
        String[] tokens = xpath.split("/");
        for (int i = 0; i < tokens.length; ++i) {
            PlasmaProperty prop;
            int attr;
            String token;
            int right;
            if (i > 0) {
                buf.append("/");
            }
            if ((right = (token = tokens[i]).indexOf("[")) >= 0) {
                token = token.substring(0, right);
            }
            if ((attr = token.indexOf("@")) == 0) {
                token = token.substring(1);
            }
            if (!(prop = (PlasmaProperty)contextType.getProperty(token)).getType().isDataType()) {
                contextType = prop.getType();
                if (i == tokens.length - 1) {
                    throw new StoreMappingException("expected xpath '" + xpath + "' termination with a data property not, " + prop);
                }
            } else {
                this.endpointProperty = prop;
            }
            buf.append(prop.getName());
        }
        this.propertyPath = buf.toString();
        DataFlavor flavor = this.endpointProperty.getDataFlavor();
        DataType dataType = DataType.valueOf((String)this.endpointProperty.getType().getName());
        switch (flavor) {
            case string: {
                this.maxLength = this.getStringTypeMaxLength(this.endpointProperty, dataType, flavor);
                break;
            }
            case integral: {
                this.maxLength = this.getIntegralTypeMaxLength(this.endpointProperty, dataType, flavor);
                break;
            }
            case real: {
                this.maxLength = this.getRealTypeMaxLength(this.endpointProperty, dataType, flavor);
                break;
            }
            case temporal: {
                this.maxLength = this.getTemporalTypeMaxLength(this.endpointProperty, dataType, flavor);
                break;
            }
            case other: {
                throw new IllegalArgumentException("data flavor '" + flavor + "' not supported for row key fields");
            }
        }
    }

    private int getRealTypeMaxLength(PlasmaProperty prop, DataType dataType, DataFlavor flavor) {
        if (prop.getValueConstraint() == null) {
            throw new MissingRequiredConstraintException("expected value contraint for property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and real properties used in row key fields must be annotated with a value constraint and the total-digits set");
        }
        ValueConstraint constraint = prop.getValueConstraint();
        if (constraint.getTotalDigits() == null || constraint.getTotalDigits().length() == 0) {
            throw new MissingRequiredConstraintException("expected value contraint total-digits for real property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and real properties used in row key fields must be annotated with a value constraint with the total-digits set");
        }
        int totalDigits = Integer.parseInt(constraint.getTotalDigits());
        if (totalDigits == 0) {
            throw new MissingRequiredConstraintException("expected value contraint with non-zero total-digits for real property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and real properties used in row key fields must be annotated with a value constraint with the total-digits set");
        }
        return Integer.parseInt(constraint.getTotalDigits());
    }

    private int getStringTypeMaxLength(PlasmaProperty prop, DataType dataType, DataFlavor flavor) {
        if (prop.getValueConstraint() == null) {
            throw new MissingRequiredConstraintException("expected value contraint for string property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and string properties used in row key fields must be annotated with a value constraint and the max-length set");
        }
        ValueConstraint constraint = prop.getValueConstraint();
        if (constraint.getMaxLength() == null || constraint.getMaxLength().length() == 0) {
            throw new MissingRequiredConstraintException("expected value contraint max-length for string property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and string properties used in row key fields must be annotated with a value constraint with the max-length set");
        }
        int maxLength = Integer.parseInt(constraint.getMaxLength());
        if (maxLength == 0) {
            throw new MissingRequiredConstraintException("expected value contraint with non-zero max-length for string property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and string properties used in row key fields must be annotated with a value constraint with the max-length set");
        }
        return Integer.parseInt(constraint.getMaxLength());
    }

    private int getIntegralTypeMaxLength(PlasmaProperty prop, DataType dataType, DataFlavor flavor) {
        int result = 0;
        if (prop.getValueConstraint() != null && prop.getValueConstraint().getTotalDigits() != null && prop.getValueConstraint().getTotalDigits().length() > 0) {
            result = Integer.parseInt(prop.getValueConstraint().getTotalDigits());
            if (result == 0) {
                log.warn((Object)("expected value contraint with non-zero total-digits for integral property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and integral properties used in row key fields must be annotated with a " + "value constraint with the total-digits set - ignoring, using default"));
                result = this.getDefaultIntegralTypeMaxLength(prop, dataType, flavor);
            }
        } else {
            result = this.getDefaultIntegralTypeMaxLength(prop, dataType, flavor);
        }
        return result;
    }

    private int getDefaultIntegralTypeMaxLength(PlasmaProperty prop, DataType dataType, DataFlavor flavor) {
        int result;
        switch (dataType) {
            case Short: {
                log.warn((Object)("expected value contraint total-digits for integral property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and integral properties used in " + "row key fields should be annotated with a value constraint with the total-digits set" + " - defaulting to max size for datatype, " + dataType + "."));
                result = String.valueOf(Short.MAX_VALUE).length();
                break;
            }
            case Int: {
                log.warn((Object)("expected value contraint total-digits for integral property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and integral properties used in " + "row key fields should be annotated with a value constraint with the total-digits set" + " - defaulting to max size for datatype, " + dataType + "."));
                result = String.valueOf(Integer.MAX_VALUE).length();
                break;
            }
            case Long: {
                log.warn((Object)("expected value contraint total-digits for integral property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and integral properties used in " + "row key fields should be annotated with a value constraint with the total-digits set" + " - defaulting to max size for datatype, " + dataType + "."));
                result = String.valueOf(Long.MAX_VALUE).length();
                break;
            }
            default: {
                log.warn((Object)("cannot default max-length for datatype, " + dataType));
                throw new MissingRequiredConstraintException("expected value contraint total-digits for integral " + dataType + " property, " + prop.getContainingType().toString() + "." + prop.getName() + " - row key fields are fixed length and integral properties used in row key fields must be annotated with a value constraint with the total-digits set");
            }
        }
        return result;
    }

    private int getTemporalTypeMaxLength(PlasmaProperty prop, DataType dataType, DataFlavor flavor) {
        switch (dataType) {
            case Date: {
                return "yyyy-MM-dd'T'HH:mm:ss".length();
            }
            case DateTime: {
                return "yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'".length();
            }
            case Day: {
                return "dd".length();
            }
            case Month: {
                return "MM".length();
            }
            case MonthDay: {
                return "MM-dd".length();
            }
            case Year: {
                return "yyyy".length();
            }
            case YearMonth: {
                return "yyyy-MM".length();
            }
            case YearMonthDay: {
                return "yyyy-MM-dd".length();
            }
            case Time: {
                return "HH:mm:ss'.'SSS'Z'".length();
            }
        }
        throw new IllegalArgumentException("temporal datatype '" + dataType + "' not supported for row key fields");
    }

    public boolean equals(Object obj) {
        DataRowKeyFieldMapping other = (DataRowKeyFieldMapping)obj;
        return this.sequenceNum == other.sequenceNum;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public DataGraphMapping getDataGraph() {
        return this.dataGraph;
    }

    public DataField getUserToken() {
        return this.dataField;
    }

    public String getPathExpression() {
        return this.dataField.getPath();
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public PlasmaProperty getEndpointProperty() {
        return this.endpointProperty;
    }

    @Override
    public Object getKey(DataGraph dataGraph) {
        return this.getKey(dataGraph.getRootObject());
    }

    @Override
    public Object getKey(DataObject dataObject) {
        Object result = dataObject.get(this.getPathExpression());
        if (result == null) {
            throw new UnresolvedPathExpressionException("the configured XPath expression '" + this.getPathExpression() + "'" + " for graph root type '" + this.dataGraph.getRootType().getName() + "'" + " within table '" + this.dataGraph.getTable().getName() + "'" + " resolved to a null value - " + "use an XPath expressions which terminate with a mandatory property, " + "and return mandatory properties for data graph root types");
        }
        return result;
    }

    @Override
    public Object getKey(PlasmaType type) {
        throw new IllegalStateException("cannot derive key field value from type, " + type);
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public DataType getDataType() {
        return DataType.valueOf((String)this.endpointProperty.getType().getName());
    }

    @Override
    public DataFlavor getDataFlavor() {
        return this.endpointProperty.getDataFlavor();
    }

    public String toString() {
        return DataRowKeyFieldMapping.class.getSimpleName() + " [dataField=" + this.dataField + ", propertyPath=" + this.propertyPath + ", endpointProperty=" + this.endpointProperty + ", maxLength=" + this.maxLength + "]";
    }
}

