/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import org.cloudgraph.store.mapping.DataGraphMapping;
import org.cloudgraph.store.mapping.HashAlgorithm;
import org.cloudgraph.store.mapping.HashAlgorithmName;
import org.cloudgraph.store.mapping.KeyField;
import org.cloudgraph.store.mapping.KeyFieldCodecType;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.cloudgraph.store.mapping.codec.HashKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.KeyFieldCodec;
import org.cloudgraph.store.mapping.codec.LexicoHashKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.LexicoPadKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.LexicoSimpleKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.NativeKeyFieldCodec;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaType;

public abstract class KeyFieldMapping {
    protected int sequenceNum;
    protected int totalFields;
    public static Charset CHARSET = Charset.forName("UTF-8");
    protected DataGraphMapping dataGraph;
    private KeyField field;
    protected KeyFieldCodec keyFieldCodec;

    private KeyFieldMapping() {
    }

    public KeyFieldMapping(DataGraphMapping dataGraph, KeyField field, int sequenceNum, int totalFields) {
        this.dataGraph = dataGraph;
        this.field = field;
        this.sequenceNum = sequenceNum;
        this.totalFields = totalFields;
    }

    public int getSeqNum() {
        return this.sequenceNum;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public abstract Object getKey(DataGraph var1);

    public abstract Object getKey(DataObject var1);

    public abstract Object getKey(PlasmaType var1);

    public abstract int getMaxLength();

    public abstract DataType getDataType();

    public abstract DataFlavor getDataFlavor();

    public KeyFieldCodecType getCodecType() {
        return this.field.getCodecType();
    }

    public KeyFieldCodec getCodec() {
        if (this.keyFieldCodec == null) {
            switch (this.field.getCodecType()) {
                case LEXICOPAD: {
                    this.keyFieldCodec = new LexicoPadKeyFieldCodec(this);
                    break;
                }
                case HASH: {
                    if (this.dataGraph.getTable().hasHashAlgorithm() && this.dataGraph.getTable().getTable().getHashAlgorithm() != null) {
                        HashAlgorithm algo = this.dataGraph.getTable().getTable().getHashAlgorithm();
                        this.keyFieldCodec = new HashKeyFieldCodec(this, algo.getName());
                    }
                    if (this.keyFieldCodec != null) break;
                    this.keyFieldCodec = new HashKeyFieldCodec(this, HashAlgorithmName.JENKINS_32);
                    break;
                }
                case LEXICOHASH: {
                    if (this.dataGraph.getTable().hasHashAlgorithm() && this.dataGraph.getTable().getTable().getHashAlgorithm() != null) {
                        HashAlgorithm algo = this.dataGraph.getTable().getTable().getHashAlgorithm();
                        this.keyFieldCodec = new LexicoHashKeyFieldCodec(this, algo.getName());
                    }
                    if (this.keyFieldCodec != null) break;
                    this.keyFieldCodec = new LexicoHashKeyFieldCodec(this, HashAlgorithmName.JENKINS_32);
                    break;
                }
                case NATIVE: {
                    this.keyFieldCodec = new NativeKeyFieldCodec(this);
                    break;
                }
                case LEXICOSIMPLE: {
                    this.keyFieldCodec = new LexicoSimpleKeyFieldCodec(this);
                    break;
                }
                case CUSTOM: {
                    if (this.field.getCustomCodecClass() == null) {
                        throw new StoreMappingException("custom codec class is required for custom codec mappings - please add a qualified class name for the custom codec");
                    }
                    try {
                        Class<?> codecClass = Class.forName(this.field.getCustomCodecClass());
                        Class[] types = new Class[]{KeyFieldMapping.class};
                        Constructor<?> constructor = codecClass.getConstructor(types);
                        Object[] args = new Object[]{this};
                        this.keyFieldCodec = (KeyFieldCodec)constructor.newInstance(args);
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new StoreMappingException(e);
                    }
                }
                default: {
                    this.keyFieldCodec = new LexicoPadKeyFieldCodec(this);
                }
            }
        }
        return this.keyFieldCodec;
    }
}

