/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.store.key.EdgeMetaKey;
import org.cloudgraph.store.key.EntityMetaKey;
import org.cloudgraph.store.mapping.DataGraphMapping;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.MetaField;
import org.cloudgraph.store.mapping.MetaFieldName;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;

public class MetaKeyFieldMapping
extends KeyFieldMapping {
    private static final Log log = LogFactory.getLog(MetaKeyFieldMapping.class);
    private MetaField preDefinedField;

    public MetaKeyFieldMapping(DataGraphMapping dataGraph, MetaField field, int seqNum, int totalFields) {
        super(dataGraph, field, seqNum, totalFields);
        this.preDefinedField = field;
    }

    public MetaField getField() {
        return this.preDefinedField;
    }

    public MetaFieldName getName() {
        return this.preDefinedField.getName();
    }

    @Override
    public String getKey(DataGraph dataGraph) {
        return this.getKey(dataGraph.getRootObject());
    }

    @Override
    public String getKey(DataObject dataObject) {
        PlasmaType rootType = (PlasmaType)dataObject.getType();
        String result = null;
        switch (this.getName()) {
            case URI: {
                result = rootType.getURIPhysicalName();
                if (result != null && result.length() != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical URI name for type, " + rootType.toString() + ", defined - using URI"));
                }
                result = rootType.getURI();
                break;
            }
            case TYPE: {
                result = rootType.getPhysicalName();
                if (result != null && result.length() != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical name for type, " + rootType.toString() + ", defined - using logical name"));
                }
                result = rootType.getName();
                break;
            }
            case PKG: {
                result = rootType.getPackagePhysicalName();
                if (result != null && result.length() != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical package name for type, " + rootType.toString() + ", defined - using URI"));
                }
                result = rootType.getURI();
                break;
            }
            default: {
                throw new StoreMappingException("invalid row key field name, " + this.getName().name() + " - cannot get this field from a Data Graph");
            }
        }
        return result;
    }

    @Deprecated
    public byte[] getKeyBytes(DataGraph dataGraph) {
        return this.getKeyBytes(dataGraph.getRootObject());
    }

    @Deprecated
    public byte[] getKeyBytes(DataObject dataObject) {
        PlasmaType rootType = (PlasmaType)dataObject.getType();
        byte[] result = null;
        switch (this.getName()) {
            case URI: {
                result = rootType.getURIPhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical URI name bytes for type, " + rootType.toString() + ", defined - using URI bytes"));
                }
                result = rootType.getURIBytes();
                break;
            }
            case TYPE: {
                result = rootType.getPhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical name bytes for type, " + rootType.toString() + ", defined - using logical name bytes"));
                }
                result = rootType.getNameBytes();
                break;
            }
            case PKG: {
                result = rootType.getPackagePhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical package name bytes for type, " + rootType.toString() + ", defined - using URI bytes"));
                }
                result = rootType.getURIBytes();
                break;
            }
            default: {
                throw new StoreMappingException("invalid row key field name, " + this.getName().name() + " - cannot get this field from a Data Graph");
            }
        }
        return result;
    }

    @Deprecated
    public byte[] getKeyBytes(PlasmaType type, PlasmaProperty property) {
        switch (this.getName()) {
            case URI: 
            case TYPE: 
            case PKG: {
                return this.getKeyBytes(type);
            }
            case PROPERTY: {
                return this.getKeyBytes(property);
            }
        }
        throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a type or property");
    }

    @Deprecated
    public byte[] getKeyBytes(PlasmaType type, EntityMetaKey metaField) {
        switch (this.getName()) {
            case URI: 
            case TYPE: 
            case PKG: {
                return this.getKeyBytes(type);
            }
            case PROPERTY: {
                return this.getKeyBytes(metaField);
            }
        }
        throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a type or property");
    }

    @Deprecated
    public byte[] getKeyBytes(PlasmaType type, EdgeMetaKey metaField) {
        switch (this.getName()) {
            case URI: 
            case TYPE: 
            case PKG: {
                return this.getKeyBytes(type);
            }
            case PROPERTY: {
                return this.getKeyBytes(metaField);
            }
        }
        throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a type or property");
    }

    @Deprecated
    public byte[] getKeyBytes(PlasmaType type) {
        byte[] result = null;
        switch (this.getName()) {
            case URI: {
                result = type.getURIPhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical URI name bytes for type, " + type.toString() + ", defined - using URI bytes"));
                }
                result = type.getURIBytes();
                break;
            }
            case TYPE: {
                result = type.getPhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical name for type, " + type.toString() + ", defined - using logical name"));
                }
                result = type.getNameBytes();
                break;
            }
            case PKG: {
                result = type.getPackagePhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical package name bytes for type, " + type.toString() + ", defined - using URI bytes"));
                }
                result = type.getURIBytes();
                break;
            }
            default: {
                throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a type");
            }
        }
        return result;
    }

    @Override
    public Object getKey(PlasmaType type) {
        String result = null;
        switch (this.getName()) {
            case URI: {
                result = type.getURIPhysicalName();
                if (result != null && result.length() != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical URI name bytes for type, " + type.toString() + ", defined - using URI bytes"));
                }
                result = type.getURI();
                break;
            }
            case TYPE: {
                result = type.getPhysicalName();
                if (result != null && result.length() != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical name for type, " + type.toString() + ", defined - using logical name"));
                }
                result = type.getName();
                break;
            }
            case PKG: {
                result = type.getPackagePhysicalName();
                if (result != null && result.length() != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical package name bytes for type, " + type.toString() + ", defined - using URI bytes"));
                }
                result = type.getURI();
                break;
            }
            default: {
                throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a type");
            }
        }
        return result;
    }

    @Deprecated
    public byte[] getKeyBytes(PlasmaProperty property) {
        byte[] result = null;
        switch (this.getName()) {
            case PROPERTY: {
                result = property.getPhysicalNameBytes();
                if (result != null && result.length != 0) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no physical name for property, " + property.toString() + ", defined - using logical name"));
                }
                result = property.getNameBytes();
                break;
            }
            default: {
                throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a property");
            }
        }
        return result;
    }

    public byte[] getKeyBytes(EntityMetaKey metaField) {
        byte[] result = null;
        switch (this.getName()) {
            case PROPERTY: {
                result = metaField.codeAsBytes();
                break;
            }
            default: {
                throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a metaField");
            }
        }
        return result;
    }

    public byte[] getKeyBytes(EdgeMetaKey metaField) {
        byte[] result = null;
        switch (this.getName()) {
            case PROPERTY: {
                result = metaField.codeAsBytes();
                break;
            }
            default: {
                throw new StoreMappingException("invalid predefined key field name, " + this.getName().name() + " - cannot get this predefined field from a metaField");
            }
        }
        return result;
    }

    @Override
    public int getMaxLength() {
        switch (this.getName()) {
            case URI: {
                return 12;
            }
            case TYPE: {
                return 32;
            }
        }
        return 12;
    }

    @Override
    public DataType getDataType() {
        switch (this.getName()) {
            case URI: {
                return DataType.String;
            }
            case TYPE: {
                return DataType.String;
            }
        }
        return DataType.String;
    }

    @Override
    public DataFlavor getDataFlavor() {
        switch (this.getName()) {
            case URI: {
                return DataFlavor.string;
            }
            case TYPE: {
                return DataFlavor.string;
            }
        }
        return DataFlavor.string;
    }

    public String toString() {
        return "PreDefinedKeyFieldMapping [preDefinedField=" + this.preDefinedField + "]";
    }
}

