/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import commonj.sdo.Type;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.atteo.classindex.ClassIndex;
import org.cloudgraph.store.mapping.CloudGraphStoreMapping;
import org.cloudgraph.store.mapping.ColumnKeyField;
import org.cloudgraph.store.mapping.ColumnKeyModel;
import org.cloudgraph.store.mapping.Config;
import org.cloudgraph.store.mapping.ConfigProperties;
import org.cloudgraph.store.mapping.ConfigurationProperty;
import org.cloudgraph.store.mapping.DataField;
import org.cloudgraph.store.mapping.DataGraph;
import org.cloudgraph.store.mapping.DataGraphMapping;
import org.cloudgraph.store.mapping.HashAlgorithm;
import org.cloudgraph.store.mapping.HashAlgorithmName;
import org.cloudgraph.store.mapping.MetaFieldName;
import org.cloudgraph.store.mapping.Property;
import org.cloudgraph.store.mapping.RowKeyField;
import org.cloudgraph.store.mapping.RowKeyModel;
import org.cloudgraph.store.mapping.StoreMappingDataBinding;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.cloudgraph.store.mapping.StoreMappingValidationEventHandler;
import org.cloudgraph.store.mapping.Table;
import org.cloudgraph.store.mapping.TableMapping;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.env.EnvProperties;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.annotation.Namespace;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.xml.sax.SAXException;

public class StoreMapping
implements Config {
    private static Log log = LogFactory.getLog(StoreMapping.class);
    private static volatile StoreMapping instance = null;
    private static final String PROPERTY_NAME_CLOUDGRAPH_CONFIG = "cloudgraph.configuration";
    private static final String DEFAULT_CONFIG_FILE_NAME = "cloudgraph-config.xml";
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "cloudgraph.properties";
    private CloudGraphStoreMapping config;
    private ConfigProperties configProperties;
    private Charset charset = Charset.forName("UTF-8");
    private Map<QName, TableMapping> graphURIToTableMap = new HashMap<QName, TableMapping>();
    private Map<QName, DataGraphMapping> graphURIToGraphMap = new HashMap<QName, DataGraphMapping>();
    private Map<String, TableMapping> tableNameToTableMap = new HashMap<String, TableMapping>();
    private Map<String, Property> propertyNameToPropertyMap = new HashMap<String, Property>();
    private List<Class<?>> annotatedClasses = new ArrayList();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Boolean uniqueChecksVar = null;
    private Boolean tombstoneRowsVar = null;
    private Boolean tombstoneRowsOverwriteableVar = null;
    private String maprdbTablePathPrefixVar = null;

    private StoreMapping() {
        log.debug((Object)"initializing...");
        try {
            this.configProperties = new ConfigProperties();
            this.configProperties.addConfiguration((Configuration)new SystemConfiguration());
            InputStream propertiesStream = CloudGraphStoreMapping.class.getResourceAsStream(DEFAULT_PROPERTIES_FILE_NAME);
            if (propertiesStream == null) {
                propertiesStream = StoreMapping.class.getClassLoader().getResourceAsStream(DEFAULT_PROPERTIES_FILE_NAME);
            }
            if (propertiesStream != null) {
                this.configProperties.addConfiguration((Configuration)new PropertiesConfiguration(DEFAULT_PROPERTIES_FILE_NAME));
            }
        }
        catch (ConfigurationException e) {
            throw new StoreMappingException(e);
        }
        try {
            InputStream stream;
            for (Class c : ClassIndex.getAnnotated(org.cloudgraph.store.mapping.annotation.Table.class)) {
                this.annotatedClasses.add(c);
            }
            String mappingFileName = EnvProperties.instance().getProperty(PROPERTY_NAME_CLOUDGRAPH_CONFIG);
            if (mappingFileName == null) {
                mappingFileName = DEFAULT_CONFIG_FILE_NAME;
            }
            if ((stream = CloudGraphStoreMapping.class.getResourceAsStream(mappingFileName)) == null) {
                stream = StoreMapping.class.getClassLoader().getResourceAsStream(mappingFileName);
            }
            if (stream != null) {
                if (this.annotatedClasses.size() > 0) {
                    log.warn((Object)("found mapping file '" + mappingFileName + "' - ignoring " + this.annotatedClasses.size() + " annotated classes "));
                }
                StoreMappingDataBinding configBinding = new StoreMappingDataBinding(new StoreMappingValidationEventHandler());
                this.config = this.unmarshalConfig(stream, configBinding);
            } else if (this.annotatedClasses.size() > 0) {
                try {
                    this.config = this.deriveMapping();
                }
                catch (NoSuchFieldException | SecurityException e) {
                    throw new StoreMappingException(e);
                }
            } else {
                throw new StoreMappingException("could not find configuration file resource '" + mappingFileName + "' on the current classpath and could not derive configuration from annotated classes and packages" + " - please ensure all annotated classes are on the classpath");
            }
            for (Property prop : this.config.getProperties()) {
                this.propertyNameToPropertyMap.put(prop.getName(), prop);
            }
            for (Table table : this.config.tables) {
                TableMapping tableConfig = new TableMapping(table, this);
                this.mapTable(tableConfig);
            }
        }
        catch (SAXException e) {
            throw new StoreMappingException(e);
        }
        catch (JAXBException e) {
            throw new StoreMappingException(e);
        }
    }

    private CloudGraphStoreMapping deriveMapping() throws NoSuchFieldException, SecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deriving mapping");
        }
        CloudGraphStoreMapping result = new CloudGraphStoreMapping();
        for (Class<?> c : this.annotatedClasses) {
            org.cloudgraph.store.mapping.annotation.Table tableAnnot = c.getAnnotation(org.cloudgraph.store.mapping.annotation.Table.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("discovered " + tableAnnot.name() + " table mapping"));
            }
            Table table = new Table();
            result.getTables().add(table);
            table.setName(tableAnnot.name());
            table.setDataColumnFamilyName(tableAnnot.dataColumnFamilyName());
            table.setTombstoneRows(tableAnnot.tombstoneRows());
            table.setTombstoneRowsOverwriteable(tableAnnot.tombstoneRowsOverwriteable());
            table.setUniqueChecks(tableAnnot.uniqueChecks());
            if (tableAnnot.hashAlgorithm().ordinal() != HashAlgorithmName.NONE.ordinal()) {
                HashAlgorithm hash = new HashAlgorithm();
                hash.setName(tableAnnot.hashAlgorithm());
                table.setHashAlgorithm(hash);
            }
            DataGraph dataGraph = new DataGraph();
            table.getDataGraphs().add(dataGraph);
            org.plasma.sdo.annotation.Type typeAnnot = c.getAnnotation(org.plasma.sdo.annotation.Type.class);
            String typeName = typeAnnot.name();
            if (typeName == null || typeName.trim().length() == 0) {
                typeName = c.getSimpleName();
            }
            dataGraph.setType(typeName);
            Namespace namespaceAnnot = c.getPackage().getAnnotation(Namespace.class);
            dataGraph.setUri(namespaceAnnot.uri());
            if (log.isDebugEnabled()) {
                log.debug((Object)("added data graph for type: " + dataGraph.getUri() + "#" + dataGraph.getType()));
            }
            ColumnKeyModel columnModel = new ColumnKeyModel();
            columnModel.setFieldDelimiter("|");
            columnModel.setReferenceMetadataDelimiter("#");
            columnModel.setSequenceDelimiter("@");
            dataGraph.setColumnKeyModel(columnModel);
            ColumnKeyField pkgColKeyField = new ColumnKeyField();
            pkgColKeyField.setName(MetaFieldName.PKG);
            columnModel.getColumnKeyFields().add(pkgColKeyField);
            ColumnKeyField typeColKeyField = new ColumnKeyField();
            typeColKeyField.setName(MetaFieldName.TYPE);
            columnModel.getColumnKeyFields().add(typeColKeyField);
            ColumnKeyField propColKeyField = new ColumnKeyField();
            propColKeyField.setName(MetaFieldName.PROPERTY);
            columnModel.getColumnKeyFields().add(propColKeyField);
            RowKeyModel rowKeyModel = new RowKeyModel();
            dataGraph.setRowKeyModel(rowKeyModel);
            rowKeyModel.setFieldDelimiter(tableAnnot.rowKeyFieldDelimiter());
            for (Object o : c.getEnumConstants()) {
                Enum enm = (Enum)o;
                Field field = c.getField(enm.name());
                org.cloudgraph.store.mapping.annotation.RowKeyField rowKeyFieldAnnot = field.getAnnotation(org.cloudgraph.store.mapping.annotation.RowKeyField.class);
                if (rowKeyFieldAnnot == null) continue;
                RowKeyField rowKeyField = new RowKeyField();
                rowKeyModel.getRowKeyFields().add(rowKeyField);
                DataField userDefinedField = new DataField();
                rowKeyField.setDataField(userDefinedField);
                userDefinedField.setPath(field.getName());
                userDefinedField.setCodecType(rowKeyFieldAnnot.codecType());
            }
        }
        return result;
    }

    private void mapTable(TableMapping tableConfig) {
        if (this.tableNameToTableMap.get(tableConfig.getQualifiedName()) != null) {
            throw new StoreMappingException("a table definition already exists for qualified name '" + tableConfig.getQualifiedName() + "'");
        }
        this.tableNameToTableMap.put(tableConfig.getQualifiedName(), tableConfig);
        for (DataGraph graph : tableConfig.getTable().getDataGraphs()) {
            DataGraphMapping dataGraphConfig = new DataGraphMapping(graph, tableConfig);
            this.mapDataGraph(dataGraphConfig);
        }
    }

    private void unmapTable(TableMapping tableConfig) {
        if (this.tableNameToTableMap.get(tableConfig.getQualifiedName()) == null) {
            throw new StoreMappingException("table definition does not exist exists for qualified name '" + tableConfig.getQualifiedName() + "'");
        }
        for (DataGraph graph : tableConfig.getTable().getDataGraphs()) {
            DataGraphMapping dataGraphConfig = new DataGraphMapping(graph, tableConfig);
            this.unmapDataGraph(dataGraphConfig);
        }
        this.tableNameToTableMap.remove(tableConfig.getQualifiedName());
    }

    private void mapDataGraph(DataGraphMapping dataGraphConfig) {
        QName qname = new QName(dataGraphConfig.getGraph().getUri(), dataGraphConfig.getGraph().getType());
        PlasmaType configuredType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(qname.getNamespaceURI(), qname.getLocalPart());
        if (this.graphURIToTableMap.get(qname) != null) {
            throw new StoreMappingException("a data graph definition already exists within table '" + dataGraphConfig.getTable().getTable().getName() + "' for type (uri/name), " + dataGraphConfig.getGraph().getUri() + "#" + dataGraphConfig.getGraph().getType());
        }
        this.graphURIToTableMap.put(qname, dataGraphConfig.getTable());
        this.graphURIToGraphMap.put(qname, dataGraphConfig);
    }

    private void unmapDataGraph(DataGraphMapping dataGraphConfig) {
        QName qname = new QName(dataGraphConfig.getGraph().getUri(), dataGraphConfig.getGraph().getType());
        if (this.graphURIToTableMap.get(qname) == null) {
            throw new StoreMappingException("no data graph definition already exists within table '" + dataGraphConfig.getTable().getTable().getName() + "' for type (uri/name), " + dataGraphConfig.getGraph().getUri() + "#" + dataGraphConfig.getGraph().getType());
        }
        this.graphURIToTableMap.remove(qname);
    }

    private CloudGraphStoreMapping unmarshalConfig(InputStream stream, StoreMappingDataBinding binding) {
        try {
            CloudGraphStoreMapping result = (CloudGraphStoreMapping)binding.validate(stream);
            return result;
        }
        catch (UnmarshalException e) {
            throw new StoreMappingException(e);
        }
        catch (JAXBException e) {
            throw new StoreMappingException(e);
        }
    }

    @Override
    public void marshal(OutputStream stream) {
        try {
            StoreMappingDataBinding configBinding = new StoreMappingDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            configBinding.marshal(this.config, stream);
        }
        catch (JAXBException e1) {
            throw new StoreMappingException(e1);
        }
        catch (SAXException e1) {
            throw new StoreMappingException(e1);
        }
    }

    public static Config getInstance() throws StoreMappingException {
        if (instance == null) {
            StoreMapping.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() {
        if (instance == null) {
            instance = new StoreMapping();
        }
    }

    @Override
    public ConfigProperties getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public List<Property> getProperties() {
        return this.config.properties;
    }

    @Override
    public Property findProperty(String name) {
        return this.propertyNameToPropertyMap.get(name);
    }

    @Override
    public TableMapping findTable(QName typeName) {
        PlasmaType type = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(typeName.getNamespaceURI(), typeName.getLocalPart());
        return this.graphURIToTableMap.get(type.getQualifiedName());
    }

    @Override
    public TableMapping getTable(QName typeName) {
        TableMapping result = this.findTable(typeName);
        if (result == null) {
            throw new StoreMappingException("no HTable configured for  graph URI '" + typeName.toString() + "'");
        }
        return result;
    }

    @Override
    public TableMapping findTable(Type type) {
        return this.graphURIToTableMap.get(((PlasmaType)type).getQualifiedName());
    }

    @Override
    public TableMapping getTable(Type type) {
        TableMapping result = this.findTable(type);
        if (result == null) {
            throw new StoreMappingException("no HTable configured for  graph URI '" + ((PlasmaType)type).getQualifiedName() + "'");
        }
        return result;
    }

    public void addTable() {
    }

    private void collectTypeHierarchy(PlasmaType type, Map<QName, PlasmaType> map) {
        map.put(type.getQualifiedName(), type);
        this.collectBaseTypes(type, map);
        Collection<PlasmaType> coll = map.values();
        PlasmaType[] types = new PlasmaType[coll.size()];
        coll.toArray(types);
        for (int i = 0; i < types.length; ++i) {
            PlasmaType baseType = types[i];
            this.collectSubTypes(baseType, map);
        }
    }

    private void collectBaseTypes(PlasmaType type, Map<QName, PlasmaType> map) {
        for (Type t : type.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)t;
            map.put(baseType.getQualifiedName(), baseType);
            this.collectBaseTypes(baseType, map);
        }
    }

    private void collectSubTypes(PlasmaType type, Map<QName, PlasmaType> map) {
        for (Type t : type.getSubTypes()) {
            PlasmaType subType = (PlasmaType)t;
            map.put(subType.getQualifiedName(), subType);
            this.collectSubTypes(subType, map);
        }
    }

    @Override
    public TableMapping findTable(String tableName) {
        TableMapping result = this.tableNameToTableMap.get(tableName);
        return result;
    }

    @Override
    public TableMapping getTable(String tableNamespace, String tableName) {
        TableMapping result = this.tableNameToTableMap.get(tableName);
        if (result == null) {
            throw new StoreMappingException("no table configured for name '" + tableName.toString() + "'");
        }
        return result;
    }

    @Override
    public String getTableName(QName typeName) {
        TableMapping result = this.graphURIToTableMap.get(typeName);
        if (result == null) {
            throw new StoreMappingException("no HTable configured for CloudGraph '" + typeName.toString() + "'");
        }
        return result.getQualifiedName();
    }

    @Override
    public void addTable(TableMapping tableConfig) {
        this.lock.writeLock().lock();
        try {
            this.mapTable(tableConfig);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeTable(TableMapping tableConfig) {
        this.lock.writeLock().lock();
        try {
            this.unmapTable(tableConfig);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public DataGraphMapping findDataGraph(QName qname) {
        DataGraphMapping result = this.graphURIToGraphMap.get(qname);
        return result;
    }

    @Override
    public DataGraphMapping getDataGraph(QName qname) {
        DataGraphMapping result = this.graphURIToGraphMap.get(qname);
        if (result == null) {
            throw new StoreMappingException("no configured for '" + qname.toString() + "'");
        }
        return result;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean uniqueChecks() {
        if (this.uniqueChecksVar == null) {
            this.uniqueChecksVar = this.getTablePropertyBoolean(ConfigurationProperty.CLOUDGRAPH___UNIQUE___CHECKS, this.config.isUniqueChecks(), true);
        }
        return this.uniqueChecksVar;
    }

    @Override
    public boolean tombstoneRows() {
        if (this.tombstoneRowsVar == null) {
            this.tombstoneRowsVar = this.getTablePropertyBoolean(ConfigurationProperty.CLOUDGRAPH___TOMBSTONE___ROWS, this.config.isTombstoneRows(), true);
        }
        return this.tombstoneRowsVar;
    }

    @Override
    public boolean tombstoneRowsOverwriteable() {
        if (this.tombstoneRowsOverwriteableVar == null) {
            this.tombstoneRowsOverwriteableVar = this.getTablePropertyBoolean(ConfigurationProperty.CLOUDGRAPH___TOMBSTONE___ROWS___OVERWRITEABLE, this.config.isTombstoneRowsOverwriteable(), false);
        }
        return this.tombstoneRowsOverwriteableVar;
    }

    @Override
    public String maprdbTablePathPrefix() {
        if (this.maprdbTablePathPrefixVar == null) {
            this.maprdbTablePathPrefixVar = this.getTablePropertyString(ConfigurationProperty.CLOUDGRAPH___MAPRDB___TABLE___PATH___PREFIX, this.config.getMaprdbTablePathPrefix(), null);
        }
        return this.maprdbTablePathPrefixVar;
    }

    private String getTablePropertyString(ConfigurationProperty prop, String tableValue, String defaultValue) {
        Property globalProp;
        String value = this.getConfigProperties().getString(prop.value());
        String result = value != null ? value : (defaultValue != tableValue ? tableValue : ((globalProp = this.findProperty(prop.value())) != null ? globalProp.getValue() : defaultValue));
        return result;
    }

    private Boolean getTablePropertyBoolean(ConfigurationProperty prop, boolean tableValue, boolean defaultValue) {
        Property globalProp;
        String value = this.getConfigProperties().getString(prop.value());
        Boolean result = value != null ? Boolean.valueOf(value) : (defaultValue != tableValue ? Boolean.valueOf(tableValue) : ((globalProp = this.findProperty(prop.value())) != null ? Boolean.valueOf(globalProp.getValue()) : Boolean.valueOf(defaultValue)));
        return result;
    }
}

